/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.testutil.recorders;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class InMessageRecorder
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getLogger(InMessageRecorder.class);
    private final List<byte[]> inbound = new CopyOnWriteArrayList<byte[]>();

    public InMessageRecorder() {
        super("receive");
    }

    public void handleMessage(Message message) throws Fault {
        try (InputStream is = (InputStream)message.getContent(InputStream.class);){
            if (is != null) {
                byte[] b = new byte[is.available()];
                is.read(b);
                this.inbound.add(b);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("inbound: " + new String(b));
                }
                message.setContent(InputStream.class, (Object)new ByteArrayInputStream(b));
            }
        }
        catch (Exception ex) {
            throw new Fault((Throwable)ex);
        }
    }

    public List<byte[]> getInboundMessages() {
        return this.inbound;
    }
}

