/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.graphic;

import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.InputStream;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightDocument;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;

public class ICCProfileWrapper {
    private final ICC_Profile profile;
    private final ICC_ColorSpace colorSpace;

    public ICCProfileWrapper(ICC_Profile _profile) {
        this.profile = _profile;
        this.colorSpace = new ICC_ColorSpace(_profile);
    }

    public int getColorSpaceType() {
        return this.colorSpace.getType();
    }

    public ICC_Profile getProfile() {
        return this.profile;
    }

    public boolean isRGBColorSpace() {
        return 5 == this.colorSpace.getType();
    }

    public boolean isCMYKColorSpace() {
        return 9 == this.colorSpace.getType();
    }

    public boolean isGrayColorSpace() {
        return 6 == this.colorSpace.getType();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ICCProfileWrapper searchFirstICCProfile(PreflightContext context) {
        PreflightDocument document = context.getDocument();
        PDDocumentCatalog catalog = document.getDocumentCatalog();
        COSArray outputIntents = catalog.getCOSObject().getCOSArray(COSName.OUTPUT_INTENTS);
        int i = 0;
        while (outputIntents != null) {
            if (i >= outputIntents.size()) return null;
            COSDictionary outputIntentDict = (COSDictionary)outputIntents.getObject(i);
            COSBase destOutputProfile = outputIntentDict.getDictionaryObject(COSName.DEST_OUTPUT_PROFILE);
            if (destOutputProfile instanceof COSStream) {
                try (COSInputStream is = ((COSStream)destOutputProfile).createInputStream();){
                    ICCProfileWrapper iCCProfileWrapper = new ICCProfileWrapper(ICC_Profile.getInstance((InputStream)is));
                    return iCCProfileWrapper;
                }
                catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
                    context.addValidationError(new ValidationResult.ValidationError("2.1.4", "DestOutputProfile isn't a valid ICCProfile. Caused by : " + e.getMessage(), e));
                }
                catch (IOException e) {
                    context.addValidationError(new ValidationResult.ValidationError("2.1.4", "Unable to parse the ICCProfile. Caused by : " + e.getMessage(), e));
                }
            }
            ++i;
        }
        return null;
    }

    public static ICCProfileWrapper getOrSearchICCProfile(PreflightContext context) throws ValidationException {
        ICCProfileWrapper profileWrapper = context.getIccProfileWrapper();
        if (profileWrapper == null && !context.isIccProfileAlreadySearched()) {
            profileWrapper = ICCProfileWrapper.searchFirstICCProfile(context);
            context.setIccProfileAlreadySearched(true);
        }
        return profileWrapper;
    }
}

