/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.api.data;

import com.izforge.izpack.api.data.Blockable;
import com.izforge.izpack.api.data.OverrideType;
import com.izforge.izpack.api.data.binding.OsModel;
import com.izforge.izpack.util.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class PackFile
implements Serializable {
    private static final long serialVersionUID = -834377078706854909L;
    private static AtomicInteger nextInstanceId = new AtomicInteger(0);
    private final int instanceId;
    public transient String sourcePath = null;
    private String relativePath = null;
    private String targetPath = null;
    private List<OsModel> osConstraints = null;
    private File packedFile;
    private long length = 0L;
    private long size = 0L;
    private long mtime = -1L;
    private boolean isDirectory = false;
    private OverrideType override;
    private String overrideRenameTo;
    private Blockable blockable = Blockable.BLOCKABLE_NONE;
    private Map additionals = null;
    private String streamResourceName;
    private long streamOffset = -1L;
    private PackFile linkedPackFile;
    private boolean pack200Jar = false;
    private Map<String, String> pack200Properties;
    private String condition = null;

    public PackFile(File baseDir, File src, String target, List<OsModel> osList, OverrideType override, String overrideRenameTo, Blockable blockable, Map<String, String> pack200Properties) throws IOException {
        this(src, FileUtil.getRelativeFileName((File)src, (File)baseDir), target, osList, override, overrideRenameTo, blockable, null, pack200Properties);
    }

    public PackFile(File src, String relativeSourcePath, String target, List<OsModel> osList, OverrideType override, String overrideRenameTo, Blockable blockable, Map additionals, Map<String, String> pack200Properties) throws FileNotFoundException {
        this.instanceId = nextInstanceId.getAndIncrement();
        if (!src.exists()) {
            throw new FileNotFoundException("No such file: " + src);
        }
        if ('/' != File.separatorChar) {
            target = target.replace(File.separatorChar, '/');
        }
        if (target.endsWith("/")) {
            target = target.substring(0, target.length() - 1);
        }
        this.packedFile = src;
        this.sourcePath = src.getPath().replace(File.separatorChar, '/');
        this.relativePath = relativeSourcePath != null ? relativeSourcePath.replace(File.separatorChar, '/') : null;
        this.targetPath = target.replace(File.separatorChar, '/');
        this.osConstraints = osList;
        this.override = override;
        this.overrideRenameTo = overrideRenameTo;
        this.blockable = blockable;
        this.mtime = src.lastModified();
        this.isDirectory = src.isDirectory();
        if (!this.isDirectory()) {
            this.size = this.length = src.length();
        }
        this.additionals = additionals;
        if (pack200Properties != null) {
            this.pack200Jar = true;
            this.pack200Properties = pack200Properties;
        }
        if (this.isDirectory) {
            this.length = 0L;
        }
    }

    public PackFile(File baseDir, File src, String target, List<OsModel> osList, OverrideType override, String overrideRenameTo, Blockable blockable, Map additionals, Map<String, String> pack200Properties) throws IOException {
        this(src, FileUtil.getRelativeFileName((File)src, (File)baseDir), target, osList, override, overrideRenameTo, blockable, additionals, pack200Properties);
    }

    public int getId() {
        return this.instanceId;
    }

    public PackFile getLinkedPackFile() {
        return this.linkedPackFile;
    }

    public void setLinkedPackFile(PackFile linkedPackFile) {
        this.linkedPackFile = linkedPackFile;
    }

    public String getStreamResourceName() {
        return this.streamResourceName;
    }

    public void setStreamResourceName(String streamResourceName) {
        this.streamResourceName = streamResourceName;
    }

    public long getStreamOffset() {
        return this.streamOffset;
    }

    public void setStreamOffset(long offset) {
        this.streamOffset = offset;
    }

    public final List<OsModel> osConstraints() {
        return this.osConstraints;
    }

    public final File getFile() {
        return this.packedFile;
    }

    public final long length() {
        return this.length;
    }

    public final long size() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public final long lastModified() {
        return this.mtime;
    }

    public final OverrideType override() {
        return this.override;
    }

    public final String overrideRenameTo() {
        return this.overrideRenameTo;
    }

    public final Blockable blockable() {
        return this.blockable;
    }

    public final boolean isDirectory() {
        return this.isDirectory;
    }

    public final boolean isBackReference() {
        return this.linkedPackFile != null;
    }

    public final String getTargetPath() {
        return this.targetPath;
    }

    public String getRelativeSourcePath() {
        return this.relativePath;
    }

    public Map getAdditionals() {
        return this.additionals;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public boolean hasCondition() {
        return this.condition != null;
    }

    public boolean isPack200Jar() {
        return this.pack200Jar;
    }

    public Map<String, String> getPack200Properties() {
        return this.pack200Properties;
    }

    public void setLoosePackInfo(boolean loose) {
        if (loose) {
            this.length = 0L;
        }
    }
}

