/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.seam2.client;

import java.io.File;
import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.seam2.ReflectionHelper;
import org.jboss.arquillian.seam2.configuration.Seam2Configuration;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.seam.annotations.In;
import org.jboss.seam.util.Strings;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.DependencyResolvers;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependencyResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Seam2ArchiveProcessor
implements ApplicationArchiveProcessor {
    private static final String MVN_ALTERNATE_SETTINGS = "mvn.alternate.settings";
    private static final String POM_XML = "pom.xml";
    private static final String ANNOTATION_CLASS_NAME = "org.jboss.seam.annotations.In";
    @Inject
    private Instance<Seam2Configuration> configurationInstance;

    public void process(Archive<?> applicationArchive, TestClass testClass) {
        boolean shouldEnrichTestArchiveWithSeamLibraries = ((Seam2Configuration)this.configurationInstance.get()).isAutoPackage();
        if (this.hasSeamAnnotation(testClass) && shouldEnrichTestArchiveWithSeamLibraries) {
            this.appendSeamLibraries(applicationArchive);
        }
    }

    private void appendSeamLibraries(Archive<?> applicationArchive) {
        File[] seamDependencies = this.resolveSeamDependencies();
        if (applicationArchive instanceof EnterpriseArchive) {
            File[] jbossElDependencies = this.resolveArtifact("org.jboss.el:jboss-el", ((Seam2Configuration)this.configurationInstance.get()).getJbossElVersion());
            EnterpriseArchive ear = (EnterpriseArchive)applicationArchive;
            ((EnterpriseArchive)ear.addAsModules(seamDependencies)).addAsLibraries(jbossElDependencies);
        } else if (applicationArchive instanceof WebArchive) {
            WebArchive war = (WebArchive)applicationArchive;
            war.addAsLibraries(seamDependencies);
        } else {
            throw new RuntimeException("Unsupported archive format[" + applicationArchive.getClass().getSimpleName() + ", " + applicationArchive.getName() + "] for Seam 2 application. Please use WAR or EAR.");
        }
    }

    private boolean hasSeamAnnotation(TestClass testClass) {
        return ReflectionHelper.isClassPresent(ANNOTATION_CLASS_NAME) && ReflectionHelper.getFieldsWithAnnotation(testClass.getJavaClass(), In.class).size() > 0;
    }

    private File[] resolveSeamDependencies() {
        File[] seamDependencies = null;
        seamDependencies = !Strings.isEmpty((String)((Seam2Configuration)this.configurationInstance.get()).getSeamVersion()) ? this.resolveArtifact("org.jboss.seam:jboss-seam:" + ((Seam2Configuration)this.configurationInstance.get()).getSeamVersion()) : this.resolveArtifact("org.jboss.seam:jboss-seam", "2.2.2.Final");
        return seamDependencies;
    }

    private File[] resolveArtifact(String artifact, String defaultVersion) {
        File[] artifacts = null;
        try {
            artifacts = this.resolveArtifact(artifact);
        }
        catch (Exception e) {
            artifacts = this.resolveArtifact(artifact + ":" + defaultVersion);
        }
        return artifacts;
    }

    private File[] resolveArtifact(String artifact) {
        String alternateMavenSettings;
        MavenDependencyResolver mvnResolver = (MavenDependencyResolver)DependencyResolvers.use(MavenDependencyResolver.class);
        if (this.mavenIsUsed()) {
            mvnResolver.loadMetadataFromPom(POM_XML);
        }
        if ((alternateMavenSettings = System.getProperty(MVN_ALTERNATE_SETTINGS)) != null) {
            mvnResolver.configureFrom(alternateMavenSettings);
        }
        return ((MavenDependencyResolver)mvnResolver.artifact(artifact)).resolveAsFiles();
    }

    private boolean mavenIsUsed() {
        return new File(POM_XML).exists();
    }
}

