/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.seam2.configuration;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.seam2.configuration.ConfigurationTypeConverter;
import org.jboss.arquillian.seam2.configuration.Seam2Configuration;
import org.jboss.arquillian.seam2.configuration.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationImporter {
    private static final String SEAM2_EXTENSION_QUALIFIER = "seam2";
    private static final String PROPERTY_PREFIX = "arquillian.extension.seam2.";

    public Seam2Configuration from(ArquillianDescriptor descriptor) {
        Map<String, String> extensionProperties = this.extractPropertiesFromDescriptor(SEAM2_EXTENSION_QUALIFIER, descriptor);
        return this.createConfiguration(extensionProperties);
    }

    public Seam2Configuration from(Properties properties) {
        Map<String, String> fieldsWithValues = this.convertKeys(properties);
        return this.createConfiguration(fieldsWithValues);
    }

    private Map<String, String> convertKeys(Properties properties) {
        HashMap<String, String> convertedFieldsWithValues = new HashMap<String, String>();
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            String key = (String)property.getKey();
            String value = (String)property.getValue();
            convertedFieldsWithValues.put(this.convertFromPropertyKey(key), value);
        }
        return convertedFieldsWithValues;
    }

    private String convertFromPropertyKey(String key) {
        key = key.replaceAll(PROPERTY_PREFIX, "");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (c == '.') {
                c = Character.toUpperCase(key.charAt(++i));
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private Seam2Configuration createConfiguration(Map<String, String> fieldsWithValues) {
        Seam2Configuration configuration = new Seam2Configuration();
        ConfigurationTypeConverter typeConverter = new ConfigurationTypeConverter();
        List<Field> fields = SecurityActions.getAccessibleFields(Seam2Configuration.class);
        for (Field field : fields) {
            String fieldName = field.getName();
            if (!fieldsWithValues.containsKey(fieldName)) continue;
            String value = fieldsWithValues.get(fieldName);
            Class<?> fieldType = field.getType();
            try {
                field.set(configuration, typeConverter.convert(value, typeConverter.box(fieldType)));
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create Seam 2 configuration.", e);
            }
        }
        return configuration;
    }

    private Map<String, String> extractPropertiesFromDescriptor(String extenstionName, ArquillianDescriptor descriptor) {
        for (ExtensionDef extension : descriptor.getExtensions()) {
            if (!extenstionName.equals(extension.getExtensionName())) continue;
            return extension.getExtensionProperties();
        }
        return Collections.emptyMap();
    }
}

