/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.seam2.container;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.jboss.arquillian.seam2.ReflectionHelper;
import org.jboss.arquillian.seam2.util.Strings;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.jboss.seam.Component;
import org.jboss.seam.annotations.In;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;

public class Seam2Enricher
implements TestEnricher {
    private static final String ANNOTATION_CLASS_NAME = "org.jboss.seam.annotations.In";

    public void enrich(Object testCase) {
        if (ReflectionHelper.isClassPresent(ANNOTATION_CLASS_NAME)) {
            this.enrichFields(testCase);
        }
    }

    private void enrichFields(Object testCase) {
        if (Contexts.getApplicationContext() == null) {
            Lifecycle.beginCall();
        }
        List<Field> seamComponents = ReflectionHelper.getFieldsWithAnnotation(testCase.getClass(), In.class);
        for (Field seamComponent : seamComponents) {
            try {
                if (!seamComponent.isAccessible()) {
                    seamComponent.setAccessible(true);
                }
                Object component = this.resolveSeamComponent(seamComponent);
                seamComponent.set(testCase, component);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not inject seam component on field " + seamComponent, e);
            }
        }
    }

    public Object[] resolve(Method method) {
        return new Object[method.getParameterTypes().length];
    }

    private Object resolveSeamComponent(Field seamComponent) {
        In in = seamComponent.getAnnotation(In.class);
        String name = in.value();
        if (Strings.isEmpty(name)) {
            name = seamComponent.getName();
        }
        return this.getInstance(name);
    }

    private Object getInstance(String componentName) {
        return Component.getInstance((String)componentName);
    }
}

