/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core;

import java.util.Map;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.context.exception.ActionExceptionHandler;
import org.jbpm.process.core.context.exception.ExceptionHandler;
import org.jbpm.process.core.context.exception.ExceptionScope;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.ruleflow.core.factory.ActionNodeFactory;
import org.jbpm.ruleflow.core.factory.BoundaryEventNodeFactory;
import org.jbpm.ruleflow.core.factory.CompositeNodeFactory;
import org.jbpm.ruleflow.core.factory.DialectConverter;
import org.jbpm.ruleflow.core.factory.DynamicNodeFactory;
import org.jbpm.ruleflow.core.factory.EndNodeFactory;
import org.jbpm.ruleflow.core.factory.EventNodeFactory;
import org.jbpm.ruleflow.core.factory.FaultNodeFactory;
import org.jbpm.ruleflow.core.factory.ForEachNodeFactory;
import org.jbpm.ruleflow.core.factory.HumanTaskNodeFactory;
import org.jbpm.ruleflow.core.factory.JoinFactory;
import org.jbpm.ruleflow.core.factory.MilestoneNodeFactory;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.ruleflow.core.factory.RuleSetNodeFactory;
import org.jbpm.ruleflow.core.factory.SplitFactory;
import org.jbpm.ruleflow.core.factory.StartNodeFactory;
import org.jbpm.ruleflow.core.factory.SubProcessNodeFactory;
import org.jbpm.ruleflow.core.factory.TimerNodeFactory;
import org.jbpm.ruleflow.core.factory.TypeConverter;
import org.jbpm.ruleflow.core.factory.WorkItemNodeFactory;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.kie.api.definition.process.Node;
import org.kie.api.fluent.Dialect;
import org.kie.api.fluent.NodeContainerBuilder;
import org.kie.api.fluent.Variable;

public abstract class RuleFlowNodeContainerFactory<T extends NodeContainerBuilder<T, P>, P extends NodeContainerBuilder<P, ?>>
extends NodeFactory<T, P>
implements NodeContainerBuilder<T, P> {
    protected RuleFlowNodeContainerFactory(P nodeContainerFactory, NodeContainer nodeContainer, NodeContainer node, Object id) {
        super(nodeContainerFactory, nodeContainer, node, id);
    }

    public StartNodeFactory<T> startNode(long id) {
        return new StartNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public EndNodeFactory<T> endNode(long id) {
        return new EndNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public ActionNodeFactory<T> actionNode(long id) {
        return new ActionNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public MilestoneNodeFactory<T> milestoneNode(long id) {
        return new MilestoneNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public TimerNodeFactory<T> timerNode(long id) {
        return new TimerNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public HumanTaskNodeFactory<T> humanTaskNode(long id) {
        return new HumanTaskNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public SubProcessNodeFactory<T> subProcessNode(long id) {
        return new SubProcessNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public SplitFactory<T> splitNode(long id) {
        return new SplitFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public JoinFactory<T> joinNode(long id) {
        return new JoinFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public RuleSetNodeFactory<T> ruleSetNode(long id) {
        return new RuleSetNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public FaultNodeFactory<T> faultNode(long id) {
        return new FaultNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public EventNodeFactory<T> eventNode(long id) {
        return new EventNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public BoundaryEventNodeFactory<T> boundaryEventNode(long id) {
        return new BoundaryEventNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public CompositeNodeFactory<T> compositeNode(long id) {
        return new CompositeNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public ForEachNodeFactory<T> forEachNode(long id) {
        return new ForEachNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public DynamicNodeFactory<T> dynamicNode(long id) {
        return new DynamicNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public WorkItemNodeFactory<T> workItemNode(long id) {
        return new WorkItemNodeFactory<RuleFlowNodeContainerFactory>(this, (NodeContainer)this.node, id);
    }

    public T connection(long fromId, long toId) {
        Node from = ((NodeContainer)this.node).getNode(fromId);
        Node to = ((NodeContainer)this.node).getNode(toId);
        new ConnectionImpl(from, "DROOLS_DEFAULT", to, "DROOLS_DEFAULT");
        return (T)this;
    }

    public T exceptionHandler(Class<? extends Throwable> exceptionClass, Dialect dialect, String code) {
        return (T)this.exceptionHandler(exceptionClass.getName(), DialectConverter.fromDialect(dialect), code);
    }

    public RuleFlowNodeContainerFactory<T, P> exceptionHandler(String exception, ExceptionHandler exceptionHandler) {
        this.getScope("ExceptionScope", ExceptionScope.class).setExceptionHandler(exception, exceptionHandler);
        return this;
    }

    public RuleFlowNodeContainerFactory<T, P> exceptionHandler(String exception, String dialect, String action) {
        ActionExceptionHandler exceptionHandler = new ActionExceptionHandler();
        exceptionHandler.setAction(new DroolsConsequenceAction(dialect, action));
        return this.exceptionHandler(exception, exceptionHandler);
    }

    private <S extends Context> S getScope(String scopeType, Class<S> scopeClass) {
        ContextContainer contextContainer = (ContextContainer)this.node;
        Context scope = contextContainer.getDefaultContext(scopeType);
        if (scope == null) {
            try {
                scope = (Context)scopeClass.newInstance();
            }
            catch (ReflectiveOperationException ex) {
                throw new IllegalStateException(ex);
            }
            contextContainer.addContext(scope);
            contextContainer.setDefaultContext(scope);
        }
        return (S)((Context)scopeClass.cast(scope));
    }

    public <V> T variable(Variable<V> variable) {
        this.getScope("VariableScope", VariableScope.class).getVariables().add(this.convertVariable(variable));
        return (T)this;
    }

    private <V> org.jbpm.process.core.context.variable.Variable convertVariable(Variable<V> variable) {
        org.jbpm.process.core.context.variable.Variable result = new org.jbpm.process.core.context.variable.Variable();
        result.setName(variable.getName());
        result.setType(TypeConverter.fromType(variable.getClass()));
        if (variable.getValue() != null) {
            result.setValue(variable.getValue());
        }
        if (variable.getMetadata() != null) {
            for (Map.Entry entry : variable.getMetadata().entrySet()) {
                result.setMetaData((String)entry.getKey(), entry.getValue());
            }
        }
        return result;
    }
}

