/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.node;

import java.util.Collections;
import java.util.Map;
import org.jbpm.workflow.core.Constraint;
import org.jbpm.workflow.core.impl.ConnectionRef;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.node.Constrainable;
import org.kie.api.definition.process.Connection;
import org.kie.api.definition.process.NodeType;

public class Split
extends NodeImpl
implements Constrainable {
    public static final int TYPE_UNDEFINED = 0;
    public static final int TYPE_AND = 1;
    public static final int TYPE_XOR = 2;
    public static final int TYPE_OR = 3;
    public static final int TYPE_XAND = 4;
    private static final long serialVersionUID = 510L;
    private int type;

    public Split() {
        super(NodeType.COMPLEX_GATEWAY);
        this.type = 0;
    }

    public Split(int type) {
        super(Split.fromType(type));
        this.type = type;
    }

    public void setType(int type) {
        this.setNodeType(Split.fromType(type));
        this.type = type;
    }

    private static NodeType fromType(int type) {
        switch (type) {
            case 1: {
                return NodeType.PARALLEL_GATEWAY;
            }
            case 4: {
                return NodeType.EVENT_BASED_GATEWAY;
            }
            case 3: {
                return NodeType.INCLUSIVE_GATEWAY;
            }
            case 2: {
                return NodeType.EXCLUSIVE_GATEWAY;
            }
        }
        return NodeType.COMPLEX_GATEWAY;
    }

    public int getType() {
        return this.type;
    }

    public boolean isDefault(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection is null");
        }
        if (this.type == 3 || this.type == 2) {
            ConnectionRef ref = new ConnectionRef((String)connection.getMetaData().get("UniqueId"), connection.getTo().getId(), connection.getToType());
            Constraint constraint = (Constraint)this.constraints.get(ref);
            String defaultConnection = (String)this.getMetaData().get("Default");
            String connectionId = (String)connection.getMetaData().get("UniqueId");
            if (constraint != null) {
                return constraint.isDefault();
            }
            return constraint == null && connectionId.equals(defaultConnection);
        }
        throw new UnsupportedOperationException("Constraints are only supported with XOR or OR split types, not with: " + this.getType());
    }

    @Override
    public Constraint getConstraint(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection is null");
        }
        if (this.type == 3 || this.type == 2) {
            ConnectionRef ref = new ConnectionRef((String)connection.getMetaData().get("UniqueId"), connection.getTo().getId(), connection.getToType());
            return (Constraint)this.constraints.get(ref);
        }
        throw new UnsupportedOperationException("Constraints are only supported with XOR or OR split types, not with: " + this.getType());
    }

    @Override
    public Constraint internalGetConstraint(ConnectionRef ref) {
        return (Constraint)this.constraints.get(ref);
    }

    @Override
    public void setConstraint(Connection connection, Constraint constraint) {
        if (this.type == 3 || this.type == 2) {
            if (connection == null) {
                throw new IllegalArgumentException("connection is null");
            }
            if (!this.getDefaultOutgoingConnections().contains(connection)) {
                throw new IllegalArgumentException("connection is unknown:" + connection);
            }
        } else {
            throw new UnsupportedOperationException("Constraints are only supported with XOR or OR split types, not with type:" + this.getType());
        }
        this.addConstraint(new ConnectionRef((String)connection.getMetaData().get("UniqueId"), connection.getTo().getId(), connection.getToType()), constraint);
    }

    @Override
    public void addConstraint(ConnectionRef connectionRef, Constraint constraint) {
        if (connectionRef == null) {
            throw new IllegalArgumentException("A split node only accepts constraints linked to a connection");
        }
        this.constraints.put(connectionRef, constraint);
    }

    @Override
    public Map<ConnectionRef, Constraint> getConstraints() {
        return Collections.unmodifiableMap(this.constraints);
    }

    @Override
    public void validateAddIncomingConnection(String type, Connection connection) {
        super.validateAddIncomingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("This type of node [" + connection.getTo().getMetaData().get("UniqueId") + ", " + connection.getTo().getName() + "] only accepts default incoming connection type!");
        }
        if (!this.getIncomingConnections("DROOLS_DEFAULT").isEmpty()) {
            throw new IllegalArgumentException("This type of node [" + connection.getTo().getMetaData().get("UniqueId") + ", " + connection.getTo().getName() + "] cannot have more than one incoming connection!");
        }
    }

    @Override
    public void validateAddOutgoingConnection(String type, Connection connection) {
        super.validateAddOutgoingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("This type of node [" + connection.getFrom().getMetaData().get("UniqueId") + ", " + connection.getFrom().getName() + "] only accepts default outgoing connection type!");
        }
    }

    @Override
    public void removeOutgoingConnection(String type, Connection connection) {
        super.removeOutgoingConnection(type, connection);
        this.removeConstraint(connection);
    }

    public void removeConstraint(Connection connection) {
        ConnectionRef ref = new ConnectionRef((String)connection.getMetaData().get("UniqueId"), connection.getTo().getId(), connection.getToType());
        this.internalRemoveConstraint(ref);
    }

    public void internalRemoveConstraint(ConnectionRef ref) {
        this.constraints.remove(ref);
    }
}

