/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.lock;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import org.jbpm.runtime.manager.spi.RuntimeManagerLock;

public class SelfReleaseRuntimeManagerLock
implements RuntimeManagerLock {
    private SelfRelaseCapableSync sync = new SelfRelaseCapableSync();
    private List<StackTraceElement[]> traces = new ArrayList<StackTraceElement[]>();
    private long currentThreadId = -1L;

    @Override
    public void lock() {
        this.sync.lock();
        this.addTraces();
    }

    @Override
    public boolean tryLock(long units, TimeUnit timeUnit) throws InterruptedException {
        boolean outcome = this.sync.tryAcquireNanos(1, timeUnit.toMillis(units));
        if (outcome) {
            this.addTraces();
        }
        return outcome;
    }

    @Override
    public void lockInterruptible() throws InterruptedException {
        this.sync.acquireInterruptibly(1);
        this.addTraces();
    }

    private void addTraces() {
        long newThreadId = Thread.currentThread().getId();
        if (this.currentThreadId < 0L || this.currentThreadId != newThreadId) {
            this.currentThreadId = newThreadId;
            this.traces.clear();
        }
        this.traces.add(Thread.currentThread().getStackTrace());
    }

    @Override
    public void unlock() {
        if (this.currentThreadId == Thread.currentThread().getId() && this.sync.getHoldCount() == 1) {
            this.traces.clear();
        }
        this.sync.release(1);
    }

    @Override
    public void forceUnlock() {
        this.sync.release(1);
        this.traces.clear();
        this.currentThreadId = -1L;
    }

    @Override
    public boolean hasQueuedThreads() {
        return this.sync.hasQueuedThreads();
    }

    @Override
    public boolean isHeldByCurrentThread() {
        return this.sync.isHeldExclusively();
    }

    @Override
    public int getQueueLength() {
        return this.sync.getQueueLength();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SelfReleaseRuntimeManagerLock [");
        builder.append(this.sync);
        builder.append("]\n");
        builder.append("--------CURRENT REENTRANT STACKTRACE-----------------------\n");
        for (int i = 0; i < this.traces.size(); ++i) {
            builder.append("\tSTACKTRACE " + i + "\n");
            StackTraceElement[] trace = this.traces.get(i);
            for (int j = 0; j < trace.length; ++j) {
                builder.append("\t\t\t" + trace[j] + "\n");
            }
        }
        builder.append("--------END CURRENT REENTRANT STACKTRACE-------------------\n");
        return builder.toString();
    }

    static class SelfRelaseCapableSync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 1L;

        SelfRelaseCapableSync() {
        }

        final boolean nonfairTryAcquire(int acquires) {
            Thread current = Thread.currentThread();
            int c = this.getState();
            if (c == 0) {
                if (this.compareAndSetState(0, acquires)) {
                    this.setExclusiveOwnerThread(current);
                    return true;
                }
            } else if (current == this.getExclusiveOwnerThread()) {
                int nextc = c + acquires;
                if (nextc < 0) {
                    throw new Error("Maximum lock count exceeded");
                }
                this.setState(nextc);
                return true;
            }
            return false;
        }

        @Override
        protected final boolean tryRelease(int releases) {
            int c = this.getState() - releases;
            boolean free = false;
            if (c == 0) {
                free = true;
                this.setExclusiveOwnerThread(null);
            }
            this.setState(c);
            return free;
        }

        final int getHoldCount() {
            return this.isHeldExclusively() ? this.getState() : 0;
        }

        final boolean isLocked() {
            return this.getState() != 0;
        }

        final void lock() {
            if (this.compareAndSetState(0, 1)) {
                this.setExclusiveOwnerThread(Thread.currentThread());
            } else {
                this.acquire(1);
            }
        }

        @Override
        protected final boolean tryAcquire(int acquires) {
            return this.nonfairTryAcquire(acquires);
        }

        @Override
        protected final boolean isHeldExclusively() {
            return this.getExclusiveOwnerThread() == Thread.currentThread();
        }
    }
}

