/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kie.internal.jaxb.StringKeyObjectValueEntry;
import org.kie.internal.jaxb.StringKeyObjectValueMapXmlAdapter;

@XmlType
@XmlAccessorType(value=XmlAccessType.FIELD)
public class StringKeyObjectValueMap
implements Map<String, Object> {
    @XmlElement(name="entry")
    public List<StringKeyObjectValueEntry> entries = new ArrayList<StringKeyObjectValueEntry>();

    public void addEntry(StringKeyObjectValueEntry newEntry) {
        this.entries.add(newEntry);
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        for (StringKeyObjectValueEntry entry : this.entries) {
            if (!key.equals(entry.getKey())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        for (StringKeyObjectValueEntry entry : this.entries) {
            Object entryVal = StringKeyObjectValueMapXmlAdapter.deserializeObject(entry.getBytes(), entry.getClassName(), entry.getKey());
            if (!value.equals(entryVal)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        for (StringKeyObjectValueEntry entry : this.entries) {
            if (key == null || !key.equals(entry.getKey())) continue;
            return StringKeyObjectValueMapXmlAdapter.deserializeObject(entry.getBytes(), entry.getClassName(), key.toString());
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        Object oldVal = this.get(key);
        StringKeyObjectValueEntry newEntry = StringKeyObjectValueMapXmlAdapter.createJaxbStringObjectMapEntry(value, key);
        this.entries.add(newEntry);
        return oldVal;
    }

    @Override
    public Object remove(Object key) {
        Iterator<StringKeyObjectValueEntry> iter = this.entries.iterator();
        while (iter.hasNext()) {
            StringKeyObjectValueEntry entry = iter.next();
            String entryKey = entry.getKey();
            if (!key.equals(entryKey)) continue;
            iter.remove();
            return StringKeyObjectValueMapXmlAdapter.deserializeObject(entry.getBytes(), entry.getClassName(), entry.getKey());
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        for (Map.Entry<? extends String, ? extends Object> entry : m.entrySet()) {
            StringKeyObjectValueEntry newEntry = StringKeyObjectValueMapXmlAdapter.createJaxbStringObjectMapEntry(entry.getValue(), entry.getKey().toString());
            this.entries.add(newEntry);
        }
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keySet = new HashSet<String>();
        for (StringKeyObjectValueEntry entry : this.entries) {
            keySet.add(entry.getKey());
        }
        return keySet;
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (StringKeyObjectValueEntry entry : this.entries) {
            Object newVal = StringKeyObjectValueMapXmlAdapter.deserializeObject(entry.getBytes(), entry.getClassName(), entry.getKey());
            values.add(newVal);
        }
        return values;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> entrySet = new HashSet<Map.Entry<String, Object>>();
        for (StringKeyObjectValueEntry entry : this.entries) {
            Object newVal = StringKeyObjectValueMapXmlAdapter.deserializeObject(entry.getBytes(), entry.getClassName(), entry.getKey());
            String key = entry.getKey();
            EntryImpl newEntry = new EntryImpl(key, newVal);
            entrySet.add(newEntry);
        }
        return entrySet;
    }

    private class EntryImpl
    implements Map.Entry<String, Object> {
        private final String key;
        private Object val;

        public EntryImpl(String key, Object val) {
            this.key = key;
            this.val = val;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.val;
        }

        @Override
        public Object setValue(Object value) {
            Object oldVal = this.val;
            this.val = value;
            return oldVal;
        }
    }
}

