/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.springboot.autoconfiguration.taskassigning;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.taskassigning.planning.TaskAssigningPlanningKieServerExtension;
import org.kie.server.springboot.autoconfiguration.taskassigning.TaskAssigningPlanningProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;

@Configuration
@ConditionalOnClass(value={KieServerImpl.class})
@EnableConfigurationProperties(value={TaskAssigningPlanningProperties.class})
public class TaskAssigningPlanningKieServerAutoConfiguration {
    private TaskAssigningPlanningProperties properties;
    private Map<String, String> restorableProperties = new HashMap<String, String>();

    public TaskAssigningPlanningKieServerAutoConfiguration(TaskAssigningPlanningProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(name={"taskAssigningPlanningServerExtension"})
    @ConditionalOnProperty(name={"kieserver.taskAssigning.planning.enabled"})
    public KieServerExtension taskAssigningPlanningServerExtension() {
        this.initProperties();
        return new TaskAssigningPlanningKieServerExtension();
    }

    @EventListener
    public void handleContextRefreshEvent(ContextClosedEvent evt) {
        this.restoreProperties();
    }

    private void initProperties() {
        this.restorableProperties.put("org.kie.server.taskAssigning.planning.ext.disabled", System.getProperty("org.kie.server.taskAssigning.planning.ext.disabled"));
        System.setProperty("org.kie.server.taskAssigning.planning.ext.disabled", Boolean.FALSE.toString());
        this.setIfConfigured("org.kie.server.taskAssigning.processRuntime.url", this.properties.getProcessRuntime().getUrl());
        this.setIfConfigured("org.kie.server.taskAssigning.processRuntime.user", this.properties.getProcessRuntime().getUser());
        this.setIfConfigured("org.kie.server.taskAssigning.processRuntime.pwd", this.properties.getProcessRuntime().getPwd());
        if (this.properties.getProcessRuntime().getTimeout() > 0) {
            this.setIfConfigured("org.kie.server.taskAssigning.processRuntime.timeout", Integer.toString(this.properties.getProcessRuntime().getTimeout()));
        }
        this.setIfConfigured("org.kie.server.taskAssigning.processRuntime.key.alias", this.properties.getProcessRuntime().getKey().getAlias());
        this.setIfConfigured("org.kie.server.taskAssigning.processRuntime.key.pwd", this.properties.getProcessRuntime().getKey().getPwd());
        this.setIfConfigured("org.kie.server.taskAssigning.processRuntime.targetUser", this.properties.getProcessRuntime().getTargetUser());
        if (this.properties.getPublishWindowSize() > 0) {
            this.setIfConfigured("org.kie.server.taskAssigning.publishWindowSize", Integer.toString(this.properties.getPublishWindowSize()));
        }
        this.setIfConfigured("org.kie.server.services.taskassigning.core.model.planningUserId", this.properties.getCore().getModel().getPlanningUserId());
        this.setIfConfigured("org.kie.server.taskAssigning.solutionSyncInterval", this.properties.getSolutionSyncInterval());
        this.setIfConfigured("org.kie.server.taskAssigning.solutionSyncQueriesShift", this.properties.getSolutionSyncQueriesShift());
        this.setIfConfigured("org.kie.server.taskAssigning.usersSyncInterval", this.properties.getUsersSyncInterval());
        this.setIfConfigured("org.kie.server.taskAssigning.waitForImprovedSolutionDuration", this.properties.getWaitForImprovedSolutionDuration());
        this.setIfConfigured("org.kie.server.taskAssigning.improveSolutionOnBackgroundDuration", this.properties.getImproveSolutionOnBackgroundDuration());
        this.setIfConfigured("org.kie.server.taskAssigning.solver.configResource", this.properties.getSolver().getConfigResource());
        this.setIfConfigured("org.kie.server.taskAssigning.solver.moveThreadCount", this.properties.getSolver().getMoveThreadCount());
        if (this.properties.getSolver().getMoveThreadBufferSize() > 1) {
            this.setIfConfigured("org.kie.server.taskAssigning.solver.moveThreadBufferSize", Integer.toString(this.properties.getSolver().getMoveThreadBufferSize()));
        }
        this.setIfConfigured("org.kie.server.taskAssigning.solver.threadFactoryClass", this.properties.getSolver().getThreadFactoryClass());
        this.setIfConfigured("org.kie.server.taskAssigning.solver.container.id", this.properties.getSolver().getContainer().getId());
        this.setIfConfigured("org.kie.server.taskAssigning.solver.container.groupId", this.properties.getSolver().getContainer().getGroupId());
        this.setIfConfigured("org.kie.server.taskAssigning.solver.container.artifactId", this.properties.getSolver().getContainer().getArtifactId());
        this.setIfConfigured("org.kie.server.taskAssigning.solver.container.version", this.properties.getSolver().getContainer().getVersion());
        this.setIfConfigured("org.kie.server.taskAssigning.userSystem.name", this.properties.getUserSystem().getName());
        this.setIfConfigured("org.kie.server.taskAssigning.userSystem.container.id", this.properties.getUserSystem().getContainer().getId());
        this.setIfConfigured("org.kie.server.taskAssigning.userSystem.container.groupId", this.properties.getUserSystem().getContainer().getGroupId());
        this.setIfConfigured("org.kie.server.taskAssigning.userSystem.container.artifactId", this.properties.getUserSystem().getContainer().getArtifactId());
        this.setIfConfigured("org.kie.server.taskAssigning.userSystem.container.version", this.properties.getUserSystem().getContainer().getVersion());
        this.setIfConfigured("org.kie.server.services.taskassigning.user.system.simple.users", this.properties.getUserSystem().getSimple().getUsers());
        this.setIfConfigured("org.kie.server.services.taskassigning.user.system.simple.skills", this.properties.getUserSystem().getSimple().getSkills());
        this.setIfConfigured("org.kie.server.services.taskassigning.user.system.simple.affinities", this.properties.getUserSystem().getSimple().getAffinities());
        if (this.properties.getRuntimeDelegate().getPageSize() > 1) {
            this.setIfConfigured("org.kie.server.taskAssigning.runtimeDelegate.pageSize", Integer.toString(this.properties.getRuntimeDelegate().getPageSize()));
        }
    }

    private void setIfConfigured(String propertyName, String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.restorableProperties.put(propertyName, System.getProperty(propertyName));
            System.getProperties().setProperty(propertyName, value);
        }
    }

    private void restoreProperties() {
        this.restorableProperties.forEach((property, value) -> {
            if (value != null) {
                System.setProperty(property, value);
            } else {
                System.clearProperty(property);
            }
        });
    }
}

