/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser.types;

import com.fasterxml.jackson.databind.JsonNode;
import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.functions.FunctionDefinition;
import io.serverlessworkflow.api.functions.FunctionRef;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.factory.WorkItemNodeFactory;
import org.kie.kogito.serverless.workflow.parser.FunctionTypeHandlerFactory;
import org.kie.kogito.serverless.workflow.parser.ParserContext;
import org.kie.kogito.serverless.workflow.parser.types.WorkItemTypeHandler;
import org.kie.kogito.serverless.workflow.utils.ServerlessWorkflowUtils;

public class ServiceTypeHandler
extends WorkItemTypeHandler {
    public static final String SERVICE_TYPE = "service";
    public static final String INTFC_SEPARATOR = "::";
    private static final String WORKITEM_PARAM_TYPE = "ParameterType";
    private static final String LANG_SEPARATOR = ":";

    @Override
    protected <T extends RuleFlowNodeContainerFactory<T, ?>> WorkItemNodeFactory<T> addFunctionArgs(Workflow workflow, WorkItemNodeFactory<T> node, FunctionRef functionRef) {
        JsonNode functionArgs = functionRef.getArguments();
        if (functionArgs == null) {
            node.workParameter(WORKITEM_PARAM_TYPE, (Object)"com.fasterxml.jackson.databind.JsonNode");
        } else {
            this.processArgs(workflow, node, functionArgs, "Parameter");
        }
        return node;
    }

    @Override
    protected <T extends RuleFlowNodeContainerFactory<T, ?>> WorkItemNodeFactory<T> fillWorkItemHandler(Workflow workflow, ParserContext context, WorkItemNodeFactory<T> node, FunctionDefinition functionDef) {
        String intfc = null;
        String method = null;
        String lang = null;
        String operation = FunctionTypeHandlerFactory.trimCustomOperation(functionDef);
        int indexOf = operation.indexOf(INTFC_SEPARATOR);
        if (indexOf != -1) {
            method = operation.substring(indexOf + INTFC_SEPARATOR.length());
            if ((indexOf = (operation = operation.substring(0, indexOf)).indexOf(LANG_SEPARATOR)) != -1) {
                intfc = operation.substring(indexOf + LANG_SEPARATOR.length());
                lang = operation.substring(0, indexOf);
            } else {
                intfc = operation;
            }
        }
        if (lang == null) {
            lang = ServerlessWorkflowUtils.resolveFunctionMetadata(functionDef, "implementation", context.getContext(), String.class, "Java");
        }
        switch (lang) {
            case "python": {
                node.workName("python_svc");
                break;
            }
            default: {
                node.workName("Service Task");
            }
        }
        return (WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)node.workParameter("Interface", intfc)).workParameter("Operation", (Object)method)).workParameter("interfaceImplementationRef", (Object)intfc)).workParameter("operationImplementationRef", (Object)method)).workParameter("implementation", (Object)lang)).metaData("Type", (Object)"Service Task");
    }

    @Override
    public String type() {
        return SERVICE_TYPE;
    }
}

