/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.suppliers;

import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import io.serverlessworkflow.api.Workflow;
import org.jbpm.compiler.canonical.ExpressionSupplier;
import org.jbpm.compiler.canonical.ProcessMetaData;
import org.jbpm.compiler.canonical.descriptors.ExpressionUtils;
import org.kie.kogito.internal.process.runtime.KogitoNode;
import org.kie.kogito.serverless.workflow.actions.ExpressionAction;
import org.kie.kogito.serverless.workflow.utils.ExpressionHandlerUtils;

public class ExpressionActionSupplier
extends ExpressionAction
implements ExpressionSupplier {
    private final ObjectCreationExpr expression;

    public static Builder of(Workflow workflow, String expr) {
        return new Builder(workflow.getExpressionLang(), ExpressionHandlerUtils.replaceExpr((Workflow)workflow, (String)expr));
    }

    private ExpressionActionSupplier(String lang, String expr, String inputVar, String outputVar) {
        super(lang, expr, inputVar, outputVar);
        ExpressionUtils.checkValid((String)lang, (String)expr);
        this.expression = ExpressionUtils.getObjectCreationExpr(ExpressionAction.class, (Object[])new Object[]{lang, expr, inputVar, outputVar});
    }

    public Expression get(KogitoNode node, ProcessMetaData metadata) {
        return this.expression;
    }

    public static class Builder {
        private final String lang;
        private final String expr;
        private String inputVar = "workflowdata";
        private String outputVar = "workflowdata";

        private Builder(String lang, String expr) {
            this.lang = lang;
            this.expr = expr;
        }

        public Builder withVarNames(String varName) {
            this.inputVar = varName;
            this.outputVar = varName;
            return this;
        }

        public Builder withVarNames(String inputVar, String outputVar) {
            this.inputVar = inputVar;
            this.outputVar = outputVar;
            return this;
        }

        public ExpressionActionSupplier build() {
            return new ExpressionActionSupplier(this.lang, this.expr, this.inputVar, this.outputVar);
        }
    }
}

