/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.runtime.persistence;

import java.net.URL;
import javax.persistence.spi.PersistenceUnitInfo;
import org.kie.server.services.jbpm.jpa.PersistenceUnitExtensionsLoader;
import org.kie.server.services.taskassigning.runtime.persistence.PlanningTaskImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskAssigningPersistenceUnitExtensionsLoader
implements PersistenceUnitExtensionsLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskAssigningPersistenceUnitExtensionsLoader.class);

    public boolean isEnabled() {
        return "false".equals(System.getProperty("org.kie.server.taskAssigning.runtime.ext.disabled"));
    }

    public void loadExtensions(PersistenceUnitInfo info) {
        LOGGER.debug("Adding the task assigning entities to the current jBPM persistent unit info.");
        String classResource = "/" + PlanningTaskImpl.class.getName().replaceAll("[.]", "/") + ".class";
        URL classURL = this.getClass().getResource(classResource);
        if (classURL != null) {
            info.getManagedClassNames().add(PlanningTaskImpl.class.getName());
            String classJarLocation = classURL.toExternalForm().split("!")[0].replace(classResource, "");
            try {
                info.getJarFileUrls().add(new URL(classJarLocation));
            }
            catch (Exception e) {
                info.getJarFileUrls().add(classURL);
            }
            LOGGER.debug("Task assigning entities where successfully added.");
        } else {
            LOGGER.error("Unexpected error, it was not possible to get resource for: {}", (Object)classResource);
        }
    }
}

