/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.engine.index.stats;

import org.dashbuilder.dataset.engine.index.DataSetFilterIndex;
import org.dashbuilder.dataset.engine.index.DataSetFunctionIndex;
import org.dashbuilder.dataset.engine.index.DataSetGroupIndex;
import org.dashbuilder.dataset.engine.index.DataSetIndex;
import org.dashbuilder.dataset.engine.index.DataSetIndexElement;
import org.dashbuilder.dataset.engine.index.DataSetSortIndex;
import org.dashbuilder.dataset.engine.index.stats.DataSetIndexStats;
import org.dashbuilder.dataset.engine.index.stats.MemSizeFormatter;
import org.dashbuilder.dataset.engine.index.visitor.DataSetIndexVisitor;

public class DataSetIndexStatsImpl
implements DataSetIndexStats,
DataSetIndexVisitor {
    private DataSetIndex index;
    private transient long buildTime = 0L;
    private transient long reuseTime = 0L;
    private transient long indexSize = 0L;
    private transient int numberOfGroupOps = 0;
    private transient int numberOfFilterOps = 0;
    private transient int numberOfSortOps = 0;
    private transient int numberOfAggFunctions = 0;
    private transient DataSetIndexElement longestBuild;
    private transient DataSetIndexElement shortestBuild;
    private transient DataSetIndexElement lessReused;
    private transient DataSetIndexElement mostReused;

    public DataSetIndexStatsImpl(DataSetIndex index) {
        this.index = index;
        index.acceptVisitor(this);
    }

    @Override
    public void visit(DataSetIndexElement element) {
        this.buildTime += element.getBuildTime();
        this.reuseTime += element.getReuseTime();
        this.indexSize += element.getEstimatedSize();
        if (this.longestBuild == null || element.getBuildTime() > this.longestBuild.getBuildTime()) {
            this.longestBuild = element;
        }
        if (this.shortestBuild == null || element.getBuildTime() > this.shortestBuild.getBuildTime()) {
            this.shortestBuild = element;
        }
        if (this.lessReused == null || element.getReuseHits() > this.lessReused.getReuseHits()) {
            this.lessReused = element;
        }
        if (this.mostReused == null || element.getReuseHits() > this.mostReused.getReuseHits()) {
            this.mostReused = element;
        }
        if (element instanceof DataSetGroupIndex) {
            ++this.numberOfGroupOps;
        }
        if (element instanceof DataSetFilterIndex) {
            ++this.numberOfFilterOps;
        }
        if (element instanceof DataSetSortIndex) {
            ++this.numberOfSortOps;
        }
        if (element instanceof DataSetFunctionIndex) {
            ++this.numberOfAggFunctions;
        }
    }

    @Override
    public double getReuseRate() {
        if (this.buildTime == 0L) {
            return 0.0;
        }
        return this.reuseTime / this.buildTime;
    }

    @Override
    public long getBuildTime() {
        return this.buildTime;
    }

    @Override
    public long getReuseTime() {
        return this.reuseTime;
    }

    @Override
    public DataSetIndexElement getLongestBuild() {
        return this.longestBuild;
    }

    @Override
    public DataSetIndexElement getShortestBuild() {
        return this.shortestBuild;
    }

    @Override
    public DataSetIndexElement getLessReused() {
        return this.lessReused;
    }

    @Override
    public DataSetIndexElement getMostReused() {
        return this.mostReused;
    }

    @Override
    public long getIndexSize() {
        return this.indexSize;
    }

    @Override
    public int getNumberOfGroupOps() {
        return this.numberOfGroupOps;
    }

    @Override
    public int getNumberOfFilterOps() {
        return this.numberOfFilterOps;
    }

    @Override
    public int getNumberOfSortOps() {
        return this.numberOfSortOps;
    }

    @Override
    public int getNumberOfAggFunctions() {
        return this.numberOfAggFunctions;
    }

    public String toString() {
        return this.toString(" ");
    }

    @Override
    public String toString(String sep) {
        StringBuilder out = new StringBuilder();
        out.append("Index size=").append(MemSizeFormatter.formatSize(this.getIndexSize())).append(sep);
        out.append("Build time=").append((double)this.getBuildTime() / 1000000.0).append(" (secs)").append(sep);
        out.append("Reuse time=").append((double)this.getReuseTime() / 1000000.0).append(" (secs)").append(sep);
        out.append("Reuse rate=").append(this.getReuseRate()).append(sep);
        out.append("#Group ops=").append(this.getNumberOfGroupOps()).append(sep);
        out.append("#Filter ops=").append(this.getNumberOfFilterOps()).append(sep);
        out.append("#Sort ops=").append(this.getNumberOfSortOps()).append(sep);
        out.append("#Agg funcs=").append(this.getNumberOfAggFunctions()).append(sep);
        return out.toString();
    }
}

