/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import org.nuxeo.client.cache.NuxeoResponseCache;
import retrofit2.Response;

public class ResultCacheInMemory
implements NuxeoResponseCache {
    protected final Cache<String, Response<?>> cache;
    protected static final int DEFAULT_CONCURRENCY_LEVEL = 10;
    protected static final int DEFAULT_MAXIMUM_SIZE = 1000;
    protected static final int DEFAULT_TIMEOUT = 10;

    public Cache<String, Response<?>> getCache() {
        return this.cache;
    }

    public ResultCacheInMemory() {
        this(10, 1000L, 10L, TimeUnit.MINUTES);
    }

    public ResultCacheInMemory(int concurrencyLevel, long maximumSize, long timeout, TimeUnit timeUnit) {
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(concurrencyLevel).maximumSize(maximumSize).expireAfterWrite(timeout, timeUnit).build();
    }

    public <T> Response<T> getResponse(String key) {
        return (Response)this.cache.getIfPresent((Object)key);
    }

    public void put(String key, Response<?> value) {
        this.cache.put((Object)key, value);
    }

    public long size() {
        return this.cache.size();
    }

    public <T> T getBody(String key) {
        Response<T> response = this.getResponse(key);
        if (response == null) {
            return null;
        }
        return (T)response.body();
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }
}

