/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.ExceptionUtils;

public class JDBCUtils {
    private static final Log log = LogFactory.getLog(JDBCUtils.class);
    public static final int MAX_TRIES = 5;

    public static <V> V callWithRetry(Callable<V> callable) throws SQLException {
        int tryNo = 1;
        while (true) {
            try {
                return callable.call();
            }
            catch (SQLException e) {
                if (tryNo >= 5) {
                    throw e;
                }
                int errorCode = e.getErrorCode();
                if (errorCode != 12516 && errorCode != 12519) {
                    throw e;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Connections open too fast, retrying in %ds: %s", tryNo, e.getMessage().replace("\n", " ")));
                }
                try {
                    Thread.sleep(1000 * tryNo);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(ie);
                }
            }
            catch (Exception e) {
                throw ExceptionUtils.runtimeException(e);
            }
            ++tryNo;
        }
    }

    public static Connection getConnection(String url, String user, String password) throws SQLException {
        return JDBCUtils.callWithRetry(() -> DriverManager.getConnection(url, user, password));
    }

    public static Connection getConnection(DataSource dataSource) throws SQLException {
        return JDBCUtils.callWithRetry(dataSource::getConnection);
    }

    public static XAConnection getXAConnection(XADataSource xaDataSource) throws SQLException {
        return JDBCUtils.callWithRetry(xaDataSource::getXAConnection);
    }
}

