/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.nio.charset.StandardCharsets;
import org.nuxeo.common.utils.UserAgentMatcher;

public class RFC2231 {
    private RFC2231() {
    }

    public static void percentEscape(StringBuilder sb, String value) {
        byte[] bytes;
        for (byte b : bytes = value.getBytes(StandardCharsets.UTF_8)) {
            if (b < 43 || b == 59 || b == 44 || b == 92 || b > 122) {
                sb.append('%');
                String s = Integer.toHexString(b & 0xFF).toUpperCase();
                if (s.length() < 2) {
                    sb.append('0');
                }
                sb.append(s);
                continue;
            }
            sb.append((char)b);
        }
    }

    public static String encodeContentDisposition(String filename, boolean inline, String userAgent) {
        StringBuilder sb = new StringBuilder(inline ? "inline; " : "attachment; ");
        if (userAgent == null) {
            userAgent = "";
        }
        if (UserAgentMatcher.isMSIE6or7(userAgent)) {
            sb.append("filename=");
            RFC2231.percentEscape(sb, filename);
        } else {
            sb.append("filename*=UTF-8''");
            RFC2231.percentEscape(sb, filename);
        }
        return sb.toString();
    }
}

