/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.nio.charset.StandardCharsets;
import org.nuxeo.common.utils.UserAgentMatcher;

public class RFC2231 {
    private static final String MIME_SPECIALS = "()<>@,;:\\\"/[]?=\t ";
    private static final String RFC2231_SPECIALS = "*'%()<>@,;:\\\"/[]?=\t ";
    private static final char[] HEX_DIGITS = "0123456789ABCDEF".toCharArray();

    private RFC2231() {
    }

    public static void percentEscape(StringBuilder sb, String value) {
        byte[] bytes;
        for (byte b : bytes = value.getBytes(StandardCharsets.UTF_8)) {
            if (b < 43 || b == 59 || b == 44 || b == 92 || b > 122) {
                sb.append('%');
                String s = Integer.toHexString(b & 0xFF).toUpperCase();
                if (s.length() < 2) {
                    sb.append('0');
                }
                sb.append(s);
                continue;
            }
            sb.append((char)b);
        }
    }

    protected static void encodeRFC2231(StringBuilder sb, String value) {
        int originalLength = sb.length();
        sb.append("*=UTF-8''");
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        boolean encoded = false;
        for (int i = 0; i < bytes.length; ++i) {
            int c = bytes[i] & 0xFF;
            if (c <= 32 || c >= 127 || RFC2231_SPECIALS.indexOf(c) != -1) {
                sb.append('%');
                sb.append(HEX_DIGITS[c >> 4]);
                sb.append(HEX_DIGITS[c & 0xF]);
                encoded = true;
                continue;
            }
            sb.append((char)c);
        }
        if (!encoded) {
            sb.setLength(originalLength);
            sb.append('=');
            sb.append(value);
        }
    }

    public static String encodeContentDisposition(String filename, boolean inline, String userAgent) {
        StringBuilder sb = new StringBuilder();
        sb.append(inline ? "inline" : "attachment");
        sb.append("; filename");
        if (userAgent == null) {
            userAgent = "";
        }
        if (UserAgentMatcher.isMSIE6or7(userAgent)) {
            sb.append("=");
            RFC2231.percentEscape(sb, filename);
        } else {
            RFC2231.encodeRFC2231(sb, filename);
        }
        return sb.toString();
    }
}

