/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.nuxeo.ecm.automation.client.model.PropertyMapSetter;

public class Document
extends DocRef {
    private static final long serialVersionUID = 1L;
    protected final String repository;
    protected final String path;
    protected final String type;
    protected final String state;
    protected final String lockOwner;
    protected final String lockCreated;
    protected final String versionLabel;
    protected final String isCheckedOut;
    protected final PropertyMap properties;
    protected final transient PropertyMapSetter propertiesSetter;
    protected final PropertyMap contextParameters;
    protected final String changeToken;
    protected final PropertyList facets;

    public Document(String id, String type, PropertyList facets, String changeToken, String path, String state, String lockOwner, String lockCreated, String repository, String versionLabel, String isCheckedOut, PropertyMap properties, PropertyMap contextParameters) {
        super(id);
        this.changeToken = changeToken;
        this.facets = facets;
        this.path = path;
        this.type = type;
        this.state = state;
        this.lockOwner = lockOwner;
        this.lockCreated = lockCreated;
        this.repository = repository;
        this.versionLabel = versionLabel;
        this.isCheckedOut = isCheckedOut;
        this.properties = properties == null ? new PropertyMap() : properties;
        this.contextParameters = contextParameters == null ? new PropertyMap() : contextParameters;
        this.propertiesSetter = new PropertyMapSetter(properties == null ? new PropertyMap() : properties);
    }

    public Document(String id, String type) {
        super(id);
        this.type = type;
        this.propertiesSetter = new PropertyMapSetter(new PropertyMap());
        this.changeToken = null;
        this.facets = null;
        this.path = null;
        this.state = null;
        this.lockOwner = null;
        this.lockCreated = null;
        this.repository = null;
        this.versionLabel = null;
        this.isCheckedOut = null;
        this.properties = new PropertyMap();
        this.contextParameters = new PropertyMap();
    }

    public String getRepository() {
        return this.repository;
    }

    @JsonProperty(value="uid")
    public String getId() {
        return this.ref;
    }

    @Override
    @JsonProperty(value="entity-type")
    public String getInputType() {
        return "document";
    }

    public String getPath() {
        return this.path;
    }

    public String getType() {
        return this.type;
    }

    public String getLock() {
        if (this.lockOwner != null && this.lockCreated != null) {
            return this.lockOwner + ":" + this.lockCreated;
        }
        return null;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public String getLockCreated() {
        return this.lockCreated;
    }

    public boolean isLocked() {
        return this.lockOwner != null;
    }

    public String getState() {
        return this.state;
    }

    public String getVersionLabel() {
        return this.versionLabel;
    }

    public Boolean isCheckedOut() {
        return this.isCheckedOut == null ? null : Boolean.valueOf(this.isCheckedOut);
    }

    public Date getLastModified() {
        return this.properties.getDate("dc:modified");
    }

    public String getTitle() {
        return this.properties.getString("dc:title");
    }

    @JsonIgnore
    public PropertyMap getProperties() {
        return this.properties;
    }

    public String getString(String key) {
        return this.properties.getString(key);
    }

    public Date getDate(String key) {
        return this.properties.getDate(key);
    }

    public Long getLong(String key) {
        return this.properties.getLong(key);
    }

    public Double getDouble(String key) {
        return this.properties.getDouble(key);
    }

    public String getString(String key, String defValue) {
        return this.properties.getString(key, defValue);
    }

    public Date getDate(String key, Date defValue) {
        return this.properties.getDate(key, defValue);
    }

    public Long getLong(String key, Long defValue) {
        return this.properties.getLong(key, defValue);
    }

    public Double getDouble(String key, Double defValue) {
        return this.properties.getDouble(key, defValue);
    }

    public void set(String key, String defValue) {
        this.propertiesSetter.set(key, defValue);
    }

    public void set(String key, Date defValue) {
        this.propertiesSetter.set(key, defValue);
    }

    public void set(String key, Long defValue) {
        this.propertiesSetter.set(key, defValue);
    }

    public void set(String key, Double defValue) {
        this.propertiesSetter.set(key, defValue);
    }

    public void set(String key, Boolean defValue) {
        this.propertiesSetter.set(key, defValue);
    }

    public void set(String key, PropertyMap defValue) {
        this.propertiesSetter.set(key, defValue);
    }

    public void set(String key, PropertyList defValue) {
        this.propertiesSetter.set(key, defValue);
    }

    public String getChangeToken() {
        return this.changeToken;
    }

    public PropertyList getFacets() {
        return this.facets;
    }

    public PropertyMap getContextParameters() {
        return this.contextParameters;
    }

    public PropertyMap getDirties() {
        return this.propertiesSetter.getDirties();
    }
}

