/*
 * (C) Copyright 2006-2011 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     bstefanescu
 */
package org.nuxeo.ecm.automation.client.model;

import java.util.ArrayList;
import java.util.List;

/**
 * @author <a href="mailto:bs@nuxeo.com">Bogdan Stefanescu</a>
 */
public class Blobs extends ArrayList<Blob> implements OperationInput {

    private static final long serialVersionUID = 1L;

    public Blobs() {
    }

    public Blobs(int size) {
        super(size);
    }

    public Blobs(List<Blob> blobs) {
        super(blobs);
    }

    @Override
    public String getInputType() {
        return "bloblist";
    }

    @Override
    public String getInputRef() {
        return null;
    }

    @Override
    public boolean isBinary() {
        return true;
    }

}
