/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.util.Date;
import org.nuxeo.ecm.automation.client.jaxrs.spi.JsonMarshaller;
import org.nuxeo.ecm.automation.client.model.DateParser;

public class DateMarshaller
implements JsonMarshaller<Date> {
    @Override
    public String getType() {
        return "date";
    }

    @Override
    public Class<Date> getJavaType() {
        return Date.class;
    }

    @Override
    public Date read(JsonParser jp) throws IOException {
        jp.nextToken();
        jp.nextToken();
        return DateParser.parseW3CDateTime(jp.getText());
    }

    @Override
    public void write(JsonGenerator jg, Object value) throws IOException {
        jg.writeStartObject();
        jg.writeStringField("entity-type", this.getType());
        jg.writeStringField("value", DateParser.formatW3CDateTime((Date)value));
        jg.writeEndObject();
    }
}

