/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.collections;

import java.util.HashMap;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.automation.jaxrs.io.documents.PaginableDocumentModelListImpl;

@Operation(id="User.GetCollections", category="Document", label="Get collections", description="Get the list of all the collections visible by the currentUser. This is returning a list of collections.", aliases={"Collection.GetCollections"})
public class GetCollectionsOperation {
    public static final String ID = "User.GetCollections";
    @Param(name="searchTerm")
    protected String searchTerm;
    @Context
    protected OperationContext ctx;
    @Context
    protected AutomationService service;

    @OperationMethod
    public PaginableDocumentModelListImpl run() throws OperationException {
        StringList sl = new StringList();
        sl.add((Object)(this.searchTerm + (this.searchTerm.endsWith("%") ? "" : "%")));
        sl.add((Object)"$currentUser");
        OperationChain chain = new OperationChain("operation");
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("queryParams", sl);
        vars.put("providerName", "default_collection");
        OperationParameters oparams = new OperationParameters("Repository.PageProvider", vars);
        chain.add(oparams);
        return (PaginableDocumentModelListImpl)this.service.run(this.ctx, chain);
    }
}

