/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.collections;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;

@Operation(id="Document.MoveCollectionMember", category="Document", label="Reorder members of a collection", description="Move member1 of a collection right after member2 of the same collection. If member2 is not sepcified, the member1 is moved to first position. Returns true if successfully moved.")
public class MoveCollectionMemberOperation {
    public static final String ID = "Document.MoveCollectionMember";
    @Context
    protected CoreSession session;
    @Context
    protected CollectionManager collectionManager;
    @Param(name="member1", required=true)
    protected DocumentModel member1;
    @Param(name="member2", required=false)
    protected DocumentModel member2 = null;

    @OperationMethod
    public boolean run(DocumentModel collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Input cannot be null. Pass a collection as input of run method.");
        }
        return this.collectionManager.moveMembers(this.session, collection, this.member1, this.member2);
    }
}

