/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services;

import java.io.IOException;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.filemanager.api.FileImporterContext;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;

@Operation(id="FileManager.ImportWithProperties", category="Services", label="Create Document from file", description="Create Document(s) from Blob(s) using the FileManagerService and set multiple properties on them.The destination container must be passed in a Context variable named currentDocument. <p>The properties are specified as <i>key=value</i> pairs separated by a new line. The key used for a property is the property xpath. To specify multi-line values you can use a \\ character followed by a new line. <p>Example:<pre>dc:title=The Document Title<br>dc:description=foo bar</pre>For updating a date, you will need to expose the value as ISO 8601 format, for instance : <p>Example:<pre>dc:title=The Document Title<br>dc:issued=@{org.nuxeo.ecm.core.schema.utils.DateParser.formatW3CDateTime(CurrentDate.date)}</pre><p>Returns back the updated document.<p>To update a multi-valued field with multiple values:<pre>custom:multivalued=a,b,c,d</pre>")
public class FileManagerImportWithProperties {
    public static final String ID = "FileManager.ImportWithProperties";
    @Context
    protected CoreSession session;
    @Context
    protected FileManager fileManager;
    @Context
    protected AutomationService as;
    @Context
    protected OperationContext context;
    @Param(name="overwrite", required=false, description="Whether to overwrite an existing file with the same title, defaults to false")
    protected boolean overwrite = false;
    @Param(name="mimeTypeCheck", required=false, description="Whether to check the blob's mime-type against the file name, defaults to true")
    protected boolean mimeTypeCheck = true;
    @Param(name="properties")
    protected Properties properties;

    protected DocumentModel getCurrentDocument() throws OperationException {
        String cdRef = (String)this.context.get((Object)"currentDocument");
        return (DocumentModel)this.as.getAdaptedValue(this.context, (Object)cdRef, DocumentModel.class);
    }

    @OperationMethod
    public DocumentModel run(Blob blob) throws OperationException, IOException {
        DocumentModel currentDocument = this.getCurrentDocument();
        String path = currentDocument.getPathAsString();
        FileImporterContext fileCreationContext = FileImporterContext.builder((CoreSession)this.session, (Blob)blob, (String)path).overwrite(this.overwrite).mimeTypeCheck(this.mimeTypeCheck).persistDocument(false).build();
        DocumentModel doc = this.fileManager.createOrUpdateDocument(fileCreationContext);
        DocumentHelper.setProperties((CoreSession)this.session, (DocumentModel)doc, (Properties)this.properties);
        if (doc.isDirty()) {
            doc = doc.getId() == null ? this.session.createDocument(doc) : this.session.saveDocument(doc);
        }
        return doc;
    }

    @OperationMethod
    public DocumentModelList run(BlobList blobs) throws OperationException, IOException {
        DocumentModelListImpl result = new DocumentModelListImpl();
        for (Blob blob : blobs) {
            result.add((Object)this.run(blob));
        }
        return result;
    }
}

