/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.coldstorage;

import java.io.Serializable;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailService;
import org.nuxeo.ecm.core.blob.ColdStorageHelper;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Document.MoveToColdStorage", category="Files", label="Move to Cold Storage", description="Move the main document content to the cold storage.")
public class MoveToColdStorage {
    public static final String ID = "Document.MoveToColdStorage";
    @Context
    protected CoreSession session;
    @Param(name="save", required=false, values={"true"})
    protected boolean save = true;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) {
        Blob thumbnail = ((ThumbnailService)Framework.getService(ThumbnailService.class)).getThumbnail(doc, this.session);
        DocumentModel documentModel = ColdStorageHelper.moveContentToColdStorage((CoreSession)this.session, (DocumentRef)doc.getRef());
        documentModel.setPropertyValue("file:content", (Serializable)thumbnail);
        if (this.save) {
            documentModel = this.session.saveDocument(documentModel);
        }
        return documentModel;
    }
}

