/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services.bulk.validation;

import java.util.Arrays;
import java.util.List;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationNotFoundException;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.core.bulk.AbstractBulkActionValidation;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.runtime.api.Framework;

public class AutomationBulkValidation
extends AbstractBulkActionValidation {
    protected List<String> getParametersToValidate() {
        return Arrays.asList("operationId", "parameters");
    }

    protected void validateCommand(BulkCommand command) throws IllegalArgumentException {
        this.validateMap("parameters", command);
        this.validateString("operationId", command);
        String operationId = (String)command.getParam("operationId");
        try {
            OperationType op = ((AutomationService)Framework.getService(AutomationService.class)).getOperation(operationId);
            String inputType = op.getInputType();
            if (inputType != null && !"document".equals(inputType) && !"documents".equals(inputType)) {
                throw new IllegalArgumentException("Unsupported operation input type : " + inputType + " in command: " + command);
            }
        }
        catch (OperationNotFoundException e) {
            throw new IllegalArgumentException("Unknown operation id " + operationId + " in command: " + command);
        }
    }
}

