/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services.directory;

import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.operations.services.directory.AbstractDirectoryOperation;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.directory.api.DirectoryService;

@Operation(id="Directory.LoadFromCSV", category="Services", label="Load directory entries from CSV file", description="Load directory entries from a CSV file. Depending on the data loading policy, duplicate entries are ignored, updated or trigger an error.")
public class LoadFromCSV
extends AbstractDirectoryOperation {
    public static final String ID = "Directory.LoadFromCSV";
    @Context
    protected OperationContext ctx;
    @Context
    protected DirectoryService directoryService;
    @Param(name="directoryName")
    protected String directoryName;
    @Param(name="dataLoadingPolicy")
    protected String dataLoadingPolicy;

    @OperationMethod
    public void run(Blob dataBlob) {
        this.validateCanManageDirectories(this.ctx);
        this.directoryService.loadFromCSV(this.directoryName, dataBlob, this.dataLoadingPolicy);
    }
}

