/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.users;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.platform.usermanager.GroupConfig;
import org.nuxeo.ecm.platform.usermanager.NuxeoGroupImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;

@Operation(id="Group.CreateOrUpdate", category="Users & Groups", label="Create or Update Group", description="Create or Update Group")
public class CreateOrUpdateGroup {
    public static final String ID = "Group.CreateOrUpdate";
    public static final String CREATE_OR_UPDATE = "createOrUpdate";
    public static final String CREATE = "create";
    public static final String UPDATE = "update";
    public static final String GROUP_SCHEMA = "group";
    protected static final String GROUP_COLON = "group:";
    public static final String GROUP_NAME = "groupname";
    public static final String GROUP_LABEL = "grouplabel";
    public static final String GROUP_DESCRIPTION = "description";
    public static final String MEMBERS = "members";
    public static final String SUB_GROUPS = "subGroups";
    public static final String PARENT_GROUPS = "parentGroups";
    public static final String GROUP_TENANTID = "tenantId";
    @Context
    protected UserManager userManager;
    @Context
    protected OperationContext ctx;
    @Param(name="groupname")
    protected String groupName;
    @Param(name="tenantId", required=false)
    protected String tenantId;
    @Param(name="grouplabel", required=false)
    protected String groupLabel;
    @Param(name="description", required=false)
    protected String groupDescription;
    @Param(name="members", required=false)
    protected StringList members;
    @Param(name="subGroups", required=false)
    protected StringList subGroups;
    @Param(name="parentGroups", required=false)
    protected StringList parentGroups;
    @Param(name="properties", required=false)
    protected Properties properties = new Properties();
    @Param(name="mode", required=false, values={"createOrUpdate", "create", "update"})
    protected String mode;

    @OperationMethod
    public void run() throws OperationException {
        String value;
        String key;
        boolean create;
        String tenantGroupName = CreateOrUpdateGroup.getTenantGroupName(this.groupName, this.tenantId);
        DocumentModel groupDoc = this.userManager.getGroupModel(tenantGroupName);
        if (groupDoc == null) {
            if (UPDATE.equals(this.mode)) {
                throw new OperationException("Cannot update non-existent group: " + this.groupName);
            }
            create = true;
            groupDoc = this.userManager.getBareGroupModel();
            groupDoc.setProperty(GROUP_SCHEMA, GROUP_NAME, (Object)tenantGroupName);
        } else {
            if (CREATE.equals(this.mode)) {
                throw new OperationException("Cannot create already-existing group: " + this.groupName);
            }
            create = false;
            this.checkCanCreateOrUpdateGroup(groupDoc);
        }
        if (this.members != null) {
            groupDoc.setProperty(GROUP_SCHEMA, MEMBERS, (Object)this.members);
        }
        if (this.subGroups != null) {
            groupDoc.setProperty(GROUP_SCHEMA, SUB_GROUPS, (Object)this.subGroups);
        }
        if (this.parentGroups != null) {
            groupDoc.setProperty(GROUP_SCHEMA, PARENT_GROUPS, (Object)this.parentGroups);
        }
        for (Map.Entry entry : Arrays.asList(new AbstractMap.SimpleEntry<String, String>(GROUP_TENANTID, this.tenantId), new AbstractMap.SimpleEntry<String, String>(GROUP_LABEL, this.groupLabel), new AbstractMap.SimpleEntry<String, String>(GROUP_DESCRIPTION, this.groupDescription))) {
            key = (String)entry.getKey();
            value = (String)entry.getValue();
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            this.properties.put((Object)key, (Object)value);
        }
        for (Map.Entry entry : this.properties.entrySet()) {
            key = (String)entry.getKey();
            value = (String)entry.getValue();
            if (key.startsWith(GROUP_COLON)) {
                key = key.substring(GROUP_COLON.length());
            }
            groupDoc.setProperty(GROUP_SCHEMA, key, (Object)value);
        }
        this.checkCanCreateOrUpdateGroup(groupDoc);
        if (create) {
            this.userManager.createGroup(groupDoc);
        } else {
            this.userManager.updateGroup(groupDoc);
        }
    }

    public static String getTenantGroupName(String groupName, String tenantId) {
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            return groupName;
        }
        return BaseSession.computeMultiTenantDirectoryId((String)tenantId, (String)groupName);
    }

    protected void checkCanCreateOrUpdateGroup(DocumentModel groupDoc) {
        NuxeoPrincipal currentUser = this.ctx.getPrincipal();
        if (!(currentUser.isAdministrator() || currentUser.isMemberOf("powerusers") && this.canCreateOrUpdateGroup(groupDoc))) {
            throw new NuxeoException("User is not allowed to create or edit groups", 403);
        }
    }

    protected boolean canCreateOrUpdateGroup(DocumentModel groupDoc) {
        GroupConfig groupConfig = this.userManager.getGroupConfig();
        NuxeoGroupImpl group = new NuxeoGroupImpl(groupDoc, groupConfig);
        Set<String> allGroups = this.computeAllGroups((NuxeoGroup)group);
        List administratorsGroups = this.userManager.getAdministratorsGroups();
        return allGroups.stream().noneMatch(administratorsGroups::contains);
    }

    protected Set<String> computeAllGroups(NuxeoGroup group) {
        HashSet<String> allGroups = new HashSet<String>();
        LinkedList<NuxeoGroup> queue = new LinkedList<NuxeoGroup>();
        queue.add(group);
        while (!queue.isEmpty()) {
            NuxeoGroup nuxeoGroup = (NuxeoGroup)queue.poll();
            allGroups.add(nuxeoGroup.getName());
            nuxeoGroup.getParentGroups().stream().filter(pg -> !allGroups.contains(pg)).map(arg_0 -> ((UserManager)this.userManager).getGroup(arg_0)).forEach(queue::add);
        }
        return allGroups;
    }
}

