/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services.bulk;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationNotFoundException;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.bulk.action.computation.AbstractBulkComputation;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.stream.StreamProcessorTopology;

public class AutomationBulkAction
implements StreamProcessorTopology {
    private static final Logger log = LogManager.getLogger(AutomationBulkAction.class);
    public static final String ACTION_NAME = "automation";
    public static final String ACTION_FULL_NAME = "bulk/automation";
    public static final String OPERATION_ID = "operationId";
    public static final String OPERATION_PARAMETERS = "parameters";

    public Topology getTopology(Map<String, String> options) {
        return Topology.builder().addComputation(AutomationComputation::new, Arrays.asList("i1:bulk/automation", "o1:bulk/status")).build();
    }

    public static class AutomationComputation
    extends AbstractBulkComputation {
        public static final String DOC_INPUT_TYPE = "document";
        public static final String DOCS_INPUT_TYPE = "documents";
        protected AutomationService service;
        protected String operationId;
        protected String inputType;
        protected Map<String, ?> params;

        public AutomationComputation() {
            super(AutomationBulkAction.ACTION_FULL_NAME);
        }

        public void startBucket(String bucketKey) {
            this.operationId = null;
            this.service = (AutomationService)Framework.getService(AutomationService.class);
            Map commandParams = this.getCurrentCommand().getParams();
            this.checkOperation((String)commandParams.get(AutomationBulkAction.OPERATION_ID));
            this.checkParams((Serializable)commandParams.get(AutomationBulkAction.OPERATION_PARAMETERS));
        }

        protected void compute(CoreSession session, List<String> ids, Map<String, Serializable> properties) {
            if (this.operationId == null) {
                return;
            }
            DocumentModelList documents = this.loadDocuments(session, ids);
            if (DOCS_INPUT_TYPE.equals(this.inputType)) {
                this.runOperationOnAllDocuments(session, documents);
            } else {
                this.runOperationOnEachDocument(session, documents);
            }
        }

        protected void runOperationOnAllDocuments(CoreSession session, DocumentModelList documents) {
            try (OperationContext ctx = new OperationContext(session);){
                ctx.setInput((Object)documents);
                this.service.run(ctx, this.operationId, this.params);
            }
            catch (OperationException e) {
                throw new NuxeoException("Operation fails on documents: " + documents, (Throwable)e);
            }
        }

        protected void runOperationOnEachDocument(CoreSession session, DocumentModelList documents) {
            for (DocumentModel doc : documents) {
                try (OperationContext ctx = new OperationContext(session);){
                    ctx.setInput((Object)doc);
                    this.service.run(ctx, this.operationId, this.params);
                }
                catch (OperationException e) {
                    throw new NuxeoException("Operation fails on doc: " + doc.getId(), (Throwable)e);
                }
            }
        }

        protected void checkOperation(String operationId) {
            block5: {
                if (StringUtils.isBlank((CharSequence)operationId)) {
                    log.warn("No operationId provided skipping command: " + this.getCurrentCommand().getId());
                    return;
                }
                try {
                    OperationType op = this.service.getOperation(operationId);
                    this.inputType = op.getInputType();
                    if (this.inputType == null || DOC_INPUT_TYPE.equals(this.inputType)) {
                        this.inputType = DOC_INPUT_TYPE;
                        break block5;
                    }
                    if (DOCS_INPUT_TYPE.equals(this.inputType)) {
                        this.inputType = DOCS_INPUT_TYPE;
                        break block5;
                    }
                    log.warn(String.format("Unsupported operation input type %s for command: %s", this.inputType, this.getCurrentCommand().getId()));
                    return;
                }
                catch (OperationNotFoundException e) {
                    log.warn(String.format("Operation '%s' not found, skipping command: %s", operationId, this.getCurrentCommand().getId()));
                    return;
                }
            }
            this.operationId = operationId;
        }

        protected void checkParams(Serializable serializable) {
            if (serializable == null) {
                this.params = null;
            } else if (serializable instanceof HashMap) {
                this.params = (Map)((Object)serializable);
            } else {
                log.warn("Unknown operation parameters type: " + serializable.getClass() + " for command: " + this.command);
                this.operationId = null;
            }
        }
    }
}

