/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.io.services;

import java.lang.reflect.Constructor;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.automation.io.services.codec.CodecDescriptor;
import org.nuxeo.ecm.automation.io.services.codec.ObjectCodec;
import org.nuxeo.ecm.automation.io.services.codec.ObjectCodecService;
import org.nuxeo.ecm.webengine.JsonFactoryManager;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class IOComponent
extends DefaultComponent {
    private static final Logger log = LogManager.getLogger(IOComponent.class);
    public static final String XP_CODECS = "codecs";
    private JsonFactoryManager jsonFactoryManager;
    private ObjectCodecService codecs;

    public <T> T getAdapter(Class<T> adapter) {
        if (ObjectCodecService.class.isAssignableFrom(adapter)) {
            return adapter.cast(this.codecs);
        }
        if (JsonFactoryManager.class.isAssignableFrom(adapter)) {
            return adapter.cast(this.jsonFactoryManager);
        }
        return (T)super.getAdapter(adapter);
    }

    public void start(ComponentContext context) {
        super.start(context);
        this.jsonFactoryManager = (JsonFactoryManager)Framework.getService(JsonFactoryManager.class);
        this.codecs = new ObjectCodecService(this.jsonFactoryManager.getJsonFactory());
        List descriptors = this.getDescriptors(XP_CODECS);
        for (CodecDescriptor d : descriptors) {
            try {
                Class<?> clazz = Class.forName(d.klass);
                Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                ObjectCodec codec = (ObjectCodec)constructor.newInstance(new Object[0]);
                this.codecs.addCodec(codec);
            }
            catch (ClassCastException | ReflectiveOperationException e) {
                String msg = String.format("Failed to register codec on '%s': error initializing class '%s' (%s).", this.name, d.getId(), e.toString());
                log.error(msg, (Throwable)e);
                this.addRuntimeMessage(RuntimeMessage.Level.ERROR, msg);
            }
        }
        this.codecs.postInit();
    }

    public void stop(ComponentContext context) throws InterruptedException {
        super.stop(context);
        this.codecs = null;
    }
}

