/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.adapters;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.mail.MessagingException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationCallback;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.impl.InvokableMethod;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.automation.jaxrs.io.operations.ExecutionRequest;
import org.nuxeo.ecm.automation.server.AutomationServer;
import org.nuxeo.ecm.automation.server.jaxrs.OperationResource;
import org.nuxeo.ecm.automation.server.jaxrs.ResponseHelper;
import org.nuxeo.ecm.core.api.AsyncService;
import org.nuxeo.ecm.core.api.AsyncStatus;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.ExceptionHelper;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.login.LoginComponent;
import org.nuxeo.runtime.transaction.TransactionHelper;

@WebAdapter(name="async", type="AsyncOperationAdapter", targetType="operation")
@Produces(value={"application/json"})
public class AsyncOperationAdapter
extends DefaultAdapter {
    public static final String NAME = "async";
    private static final Logger log = LogManager.getLogger(AsyncOperationAdapter.class);
    protected static final String STATUS_STORE_NAME = "automation";
    protected static final String TRANSIENT_STORE_SERVICE = "service";
    protected static final String TRANSIENT_STORE_TASK_ID = "taskId";
    protected static final String TRANSIENT_STORE_ERROR = "error";
    protected static final String TRANSIENT_STORE_OUTPUT = "output";
    protected static final String TRANSIENT_STORE_OUTPUT_BLOB = "blob";
    protected static final String STATUS_PATH = "status";
    protected static final String RUNNING_STATUS = "RUNNING";
    protected static final String RESULT_URL_KEY = "url";
    protected static final ObjectMapper MAPPER = new ObjectMapper();
    @Context
    protected AutomationService service;
    @Context
    protected HttpServletRequest request;
    @Context
    protected HttpServletResponse response;
    @Context
    protected CoreSession session;
    @Context
    protected AutomationServer srv;

    @POST
    public Object doPost(ExecutionRequest xreq) {
        OperationResource op = (OperationResource)this.getTarget();
        String opId = op.getId();
        if (!this.srv.accept(opId, op.isChain(), this.request)) {
            return ResponseHelper.notFound();
        }
        final String executionId = UUID.randomUUID().toString();
        OperationContext opCtx = xreq.createContext(this.request, this.response, null);
        opCtx.setCallback(new OperationCallback(){

            public void onChainEnter(OperationType chain) {
            }

            public void onChainExit() {
                AsyncOperationAdapter.this.setCompleted(executionId);
            }

            public void onOperationEnter(OperationContext context, OperationType type, InvokableMethod method, Map<String, Object> params) {
                AsyncOperationAdapter.this.enterMethod(executionId, method);
            }

            public void onOperationExit(Object output) {
                AsyncOperationAdapter.this.setOutput(executionId, (Serializable)output);
            }

            public OperationException onError(OperationException error) {
                AsyncOperationAdapter.this.setError(executionId, error);
                return error;
            }
        });
        String repoName = this.session.getRepositoryName();
        NuxeoPrincipal principal = this.session.getPrincipal();
        new Thread(() -> TransactionHelper.runInTransaction(() -> {
            LoginComponent.pushPrincipal((Principal)principal);
            try {
                CoreSession s = CoreInstance.getCoreSession((String)repoName, (NuxeoPrincipal)principal);
                opCtx.setCoreSession(s);
                this.service.run(opCtx, opId, xreq.getParams());
            }
            catch (OperationException e) {
                this.setError(executionId, e);
            }
            finally {
                LoginComponent.popPrincipal();
            }
        }), String.format("Nuxeo-AsyncOperation-%s", executionId)).start();
        try {
            String statusURL = String.format("%s%s/%s/%s", this.ctx.getServerURL(), this.getPath(), executionId, STATUS_PATH);
            return Response.status((int)202).location(new URI(statusURL)).build();
        }
        catch (URISyntaxException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @GET
    @Path(value="{executionId}/status")
    public Object status(@PathParam(value="executionId") String executionId) throws IOException, MessagingException {
        String error = this.getError(executionId);
        if (error != null) {
            throw new NuxeoException(error, 500);
        }
        if (this.isCompleted(executionId)) {
            String resURL = String.format("%s/%s", this.getPath(), executionId);
            return this.redirect(resURL);
        }
        if (this.isAsync(executionId)) {
            Serializable taskId = this.getTaskId(executionId);
            AsyncStatus result = this.getAsyncService(executionId).getStatus(taskId);
            return ResponseHelper.getResponse(result, this.request, 200);
        }
        return Response.status((int)200).entity((Object)MAPPER.writeValueAsString((Object)RUNNING_STATUS)).build();
    }

    @GET
    @Path(value="{executionId}")
    public Object result(@PathParam(value="executionId") String executionId) throws IOException, MessagingException {
        if (this.isCompleted(executionId)) {
            Object output = this.getResult(executionId);
            String error = this.getError(executionId);
            this.cleanup(executionId);
            if (error != null) {
                throw new NuxeoException(error, 500);
            }
            if (output instanceof Map) {
                HashMap map = (HashMap)output;
                Object url = ((Map)output).get(RESULT_URL_KEY);
                if (url instanceof String) {
                    map = new HashMap(map);
                    try {
                        boolean isAbsolute = new URI((String)url).isAbsolute();
                        String baseUrl = VirtualHostHelper.getBaseURL((ServletRequest)this.ctx.getRequest());
                        map.put(RESULT_URL_KEY, isAbsolute ? url : baseUrl + url);
                    }
                    catch (URISyntaxException e) {
                        log.error("Failed to parse result url {}", url);
                    }
                }
                return Response.status((int)200).entity((Object)MAPPER.writeValueAsString(map)).build();
            }
            return ResponseHelper.getResponse(output, this.request, 200);
        }
        throw new WebResourceNotFoundException("Execution with id=" + executionId + " not found");
    }

    @DELETE
    @Path(value="{executionId}")
    public Object abort(@PathParam(value="executionId") String executionId) throws IOException, MessagingException {
        if (this.exists(executionId) && !this.isCompleted(executionId)) {
            if (this.isAsync(executionId)) {
                Serializable taskId = this.getTaskId(executionId);
                return this.getAsyncService(executionId).abort(taskId);
            }
            return ResponseHelper.getResponse(RUNNING_STATUS, this.request, 200);
        }
        throw new WebResourceNotFoundException("Execution with id=" + executionId + " has completed");
    }

    protected TransientStore getTransientStore() {
        return ((TransientStoreService)Framework.getService(TransientStoreService.class)).getStore(STATUS_STORE_NAME);
    }

    protected void enterMethod(String executionId, InvokableMethod method) {
        this.getTransientStore().remove(executionId);
        if (!AsyncService.class.equals((Object)method.getAsyncService())) {
            this.getTransientStore().putParameter(executionId, TRANSIENT_STORE_SERVICE, (Serializable)((Object)method.getAsyncService().getName()));
        }
    }

    protected void setError(String executionId, Throwable t) {
        this.setError(executionId, ExceptionHelper.unwrapException((Throwable)t).getMessage());
    }

    @Deprecated(since="11.1")
    protected void setError(String executionId, String error) {
        this.getTransientStore().putParameter(executionId, TRANSIENT_STORE_ERROR, (Serializable)((Object)error));
        this.setCompleted(executionId);
    }

    public String getError(String executionId) {
        return (String)((Object)this.getTransientStore().getParameter(executionId, TRANSIENT_STORE_ERROR));
    }

    protected void setOutput(String executionId, Serializable output) {
        TransientStore ts = this.getTransientStore();
        if (this.isAsync(executionId)) {
            Serializable taskId = output instanceof AsyncStatus ? ((AsyncStatus)output).getId() : output;
            ts.putParameter(executionId, TRANSIENT_STORE_TASK_ID, taskId);
        } else {
            if (output instanceof DocumentModel) {
                this.detach((DocumentModel)output);
            } else if (output instanceof DocumentModelList) {
                ((DocumentModelList)output).forEach(this::detach);
            }
            if (output instanceof Blob) {
                ts.putParameter(executionId, TRANSIENT_STORE_OUTPUT_BLOB, (Serializable)Boolean.valueOf(true));
                ts.putBlobs(executionId, Collections.singletonList((Blob)output));
            } else if (output instanceof BlobList) {
                ts.putParameter(executionId, TRANSIENT_STORE_OUTPUT_BLOB, (Serializable)Boolean.valueOf(false));
                ts.putBlobs(executionId, (List)((BlobList)output));
            } else {
                ts.putParameter(executionId, TRANSIENT_STORE_OUTPUT, output);
            }
        }
    }

    protected Object getResult(String executionId) {
        boolean isSingle;
        AsyncService<Serializable, ?, ?> service;
        TransientStore ts = this.getTransientStore();
        if (this.isAsync(executionId) && (service = this.getAsyncService(executionId)) != null) {
            Serializable taskId = ts.getParameter(executionId, TRANSIENT_STORE_TASK_ID);
            return service.getResult(taskId);
        }
        List blobs = ts.getBlobs(executionId);
        Object output = CollectionUtils.isNotEmpty((Collection)blobs) ? ((isSingle = ((Boolean)ts.getParameter(executionId, TRANSIENT_STORE_OUTPUT_BLOB)).booleanValue()) ? blobs.get(0) : new BlobList(blobs)) : ts.getParameter(executionId, TRANSIENT_STORE_OUTPUT);
        if (output instanceof DocumentModel) {
            this.attach((DocumentModel)output);
        } else if (output instanceof DocumentModelList) {
            ((DocumentModelList)output).forEach(this::attach);
        }
        return output;
    }

    protected void attach(DocumentModel doc) {
        doc.attach(this.ctx.getCoreSession());
    }

    protected void detach(DocumentModel doc) {
        doc.detach(false);
    }

    protected boolean isAsync(String executionId) {
        return this.getTransientStore().getParameter(executionId, TRANSIENT_STORE_SERVICE) != null;
    }

    protected Serializable getTaskId(String executionId) {
        return this.getTransientStore().getParameter(executionId, TRANSIENT_STORE_TASK_ID);
    }

    protected AsyncService<Serializable, ?, ?> getAsyncService(String executionId) {
        String serviceClass = (String)((Object)this.getTransientStore().getParameter(executionId, TRANSIENT_STORE_SERVICE));
        try {
            AsyncService asyncService = (AsyncService)Framework.getService(Class.forName(serviceClass));
            return asyncService;
        }
        catch (ClassNotFoundException e) {
            log.error("AsyncService class {} not found", (Object)serviceClass);
            return null;
        }
    }

    protected void setCompleted(String executionId) {
        this.getTransientStore().setCompleted(executionId, true);
    }

    protected boolean isCompleted(String executionId) {
        if (this.isAsync(executionId)) {
            Serializable taskId = this.getTransientStore().getParameter(executionId, TRANSIENT_STORE_TASK_ID);
            return this.getAsyncService(executionId).getStatus(taskId).isCompleted();
        }
        return this.getTransientStore().isCompleted(executionId);
    }

    protected boolean exists(String executionId) {
        return this.getTransientStore().exists(executionId);
    }

    protected void cleanup(String executionId) {
        this.getTransientStore().release(executionId);
    }
}

