/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.nuxeo.ecm.automation.server.AutomationServer;
import org.nuxeo.ecm.automation.server.MarshallerRegistry;
import org.nuxeo.ecm.automation.server.RestBinding;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class AutomationServerComponent
extends DefaultComponent
implements AutomationServer {
    public static final String XP_BINDINGS = "bindings";
    public static final String XP_MARSHALLER = "marshallers";
    protected List<Class<? extends MessageBodyWriter<?>>> writers = new ArrayList();
    protected List<Class<? extends MessageBodyReader<?>>> readers = new ArrayList();

    public void start(ComponentContext context) {
        super.start(context);
        ((MarshallerRegistry)this.getExtensionPointRegistry(XP_MARSHALLER)).getContributionValues().forEach(m -> {
            this.writers.addAll(m.writers);
            this.readers.addAll(m.readers);
        });
    }

    public void stop(ComponentContext context) throws InterruptedException {
        super.stop(context);
        this.writers.clear();
        this.readers.clear();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (AutomationServer.class.isAssignableFrom(adapter)) {
            return adapter.cast(this);
        }
        return null;
    }

    @Override
    public RestBinding getOperationBinding(String name) {
        return this.getRegistryContribution(XP_BINDINGS, name).orElse(null);
    }

    @Override
    public RestBinding getChainBinding(String name) {
        return this.getRegistryContribution(XP_BINDINGS, "Chain." + name).orElse(null);
    }

    @Override
    public RestBinding[] getBindings() {
        return this.getRegistryContributions(XP_BINDINGS).toArray(new RestBinding[0]);
    }

    @Override
    public boolean accept(String name, boolean isChain, HttpServletRequest req) {
        RestBinding binding;
        if (isChain) {
            name = "Chain." + (String)name;
        }
        if ((binding = (RestBinding)this.getRegistryContribution(XP_BINDINGS, (String)name).orElse(null)) != null) {
            if (binding.isSecure && !req.isSecure()) {
                return false;
            }
            Principal principal = req.getUserPrincipal();
            if (binding.isAdministrator || binding.hasGroups()) {
                if (principal instanceof NuxeoPrincipal) {
                    NuxeoPrincipal np = (NuxeoPrincipal)principal;
                    if (binding.isAdministrator && np.isAdministrator()) {
                        return true;
                    }
                    if (binding.hasGroups()) {
                        for (String group : binding.groups) {
                            if (!np.isMemberOf(group)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public List<Class<? extends MessageBodyWriter<?>>> getWriters() {
        return this.writers;
    }

    @Override
    public List<Class<? extends MessageBodyReader<?>>> getReaders() {
        return this.readers;
    }
}

