/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.batch;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.automation.core.util.ComplexTypeJSONDecoder;
import org.nuxeo.ecm.automation.core.util.JSONBlobDecoder;
import org.nuxeo.ecm.automation.server.AutomationServer;
import org.nuxeo.ecm.automation.server.RestBinding;
import org.nuxeo.ecm.automation.server.jaxrs.batch.Batch;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchFileEntry;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchHandler;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchManager;
import org.nuxeo.ecm.automation.server.jaxrs.batch.JSONBatchBlobDecoder;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.webengine.model.exceptions.WebSecurityException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class BatchManagerComponent
extends DefaultComponent
implements BatchManager {
    private static final Logger log = LogManager.getLogger(BatchManagerComponent.class);
    public static final String CLIENT_BATCH_ID_FLAG = "allowClientGeneratedBatchId";
    public static final String DEFAULT_BATCH_HANDLER = "default";
    public static final String XP_BATCH_HANDLER = "handlers";
    protected Map<String, BatchHandler> handlers = new HashMap<String, BatchHandler>();
    protected final AtomicInteger uploadInProgress = new AtomicInteger(0);

    public void start(ComponentContext context) {
        super.start(context);
        List descriptors = this.getRegistryContributions(XP_BATCH_HANDLER);
        descriptors.forEach(d -> {
            try {
                BatchHandler handler = d.klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                handler.initialize(d.name, d.properties);
                this.handlers.put(d.name, handler);
            }
            catch (ReflectiveOperationException e) {
                log.error("Unable to instantiate batch handler", (Throwable)e);
            }
        });
    }

    public void stop(ComponentContext context) throws InterruptedException {
        super.stop(context);
        this.handlers.clear();
    }

    @Override
    @Deprecated
    public TransientStore getTransientStore() {
        return this.getHandler(DEFAULT_BATCH_HANDLER).getTransientStore();
    }

    @Override
    public Set<String> getSupportedHandlers() {
        return Collections.unmodifiableSet(this.handlers.keySet());
    }

    @Override
    public BatchHandler getHandler(String handlerName) {
        return this.handlers.get(handlerName);
    }

    @Override
    public String initBatch() {
        Batch batch = this.initBatchInternal(null);
        return batch.getKey();
    }

    @Override
    @Deprecated
    public String initBatch(String batchId, String contextName) {
        Batch batch = this.initBatchInternal(batchId);
        return batch.getKey();
    }

    protected Batch initBatchInternal(String batchId) {
        BatchHandler batchHandler = this.handlers.get(DEFAULT_BATCH_HANDLER);
        return batchHandler.newBatch(batchId);
    }

    @Override
    public Batch initBatch(String handlerName) {
        BatchHandler batchHandler;
        if (StringUtils.isEmpty((CharSequence)handlerName)) {
            handlerName = DEFAULT_BATCH_HANDLER;
        }
        if ((batchHandler = this.handlers.get(handlerName)) == null) {
            throw new IllegalArgumentException("Batch handler does not exist: " + handlerName);
        }
        return batchHandler.newBatch(null);
    }

    @Override
    public Batch getBatch(String batchId) {
        return this.handlers.values().stream().map(batchHandler -> batchHandler.getBatch(batchId)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    public void addStream(String batchId, String index, InputStream is, String name, String mime) throws IOException {
        Blob blob = Blobs.createBlob((InputStream)is);
        this.addBlob(batchId, index, blob, name, mime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBlob(String batchId, String index, Blob blob, String name, String mime) throws IOException {
        this.uploadInProgress.incrementAndGet();
        try {
            Batch batch = this.getBatch(batchId);
            if (batch == null) {
                batch = this.initBatchInternal(batchId);
            }
            batch.addFile(index, blob, name, mime);
            log.debug("Added file {} [{}] to batch {}", (Object)index, (Object)name, (Object)batch.getKey());
        }
        finally {
            this.uploadInProgress.decrementAndGet();
        }
    }

    @Override
    public void addStream(String batchId, String index, InputStream is, int chunkCount, int chunkIndex, String name, String mime, long fileSize) throws IOException {
        Blob blob = Blobs.createBlob((InputStream)is);
        this.addBlob(batchId, index, blob, chunkCount, chunkIndex, name, mime, fileSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBlob(String batchId, String index, Blob blob, int chunkCount, int chunkIndex, String name, String mime, long fileSize) throws IOException {
        this.uploadInProgress.incrementAndGet();
        try {
            Batch batch = this.getBatch(batchId);
            if (batch == null) {
                batch = this.initBatchInternal(batchId);
            }
            batch.addChunk(index, blob, chunkCount, chunkIndex, name, mime, fileSize);
            log.debug("Added chunk {} to file {} [{}] in batch {}", (Object)chunkIndex, (Object)index, (Object)name, (Object)batch.getKey());
        }
        finally {
            this.uploadInProgress.decrementAndGet();
        }
    }

    @Override
    public boolean hasBatch(String batchId) {
        return this.handlers.values().stream().anyMatch(batchHandler -> batchHandler.getBatch(batchId) != null);
    }

    @Override
    public List<Blob> getBlobs(String batchId) {
        return this.getBlobs(batchId, 0);
    }

    @Override
    public List<Blob> getBlobs(String batchId, int timeoutS) {
        Batch batch;
        if (this.uploadInProgress.get() > 0 && timeoutS > 0) {
            for (int i = 0; i < timeoutS * 5; ++i) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (this.uploadInProgress.get() == 0) break;
            }
        }
        if ((batch = this.getBatch(batchId)) == null) {
            log.error("Unable to find batch with id {}", (Object)batchId);
            return Collections.emptyList();
        }
        return batch.getBlobs();
    }

    @Override
    public Blob getBlob(String batchId, String fileIndex) {
        return this.getBlob(batchId, fileIndex, 0);
    }

    @Override
    public Blob getBlob(String batchId, String fileIndex, int timeoutS) {
        Blob blob = this.getBatchBlob(batchId, fileIndex);
        if (blob == null && timeoutS > 0 && this.uploadInProgress.get() > 0) {
            for (int i = 0; i < timeoutS * 5; ++i) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                blob = this.getBatchBlob(batchId, fileIndex);
                if (blob != null) break;
            }
        }
        if (!this.hasBatch(batchId)) {
            log.error("Unable to find batch with id {}", (Object)batchId);
            return null;
        }
        return blob;
    }

    protected Blob getBatchBlob(String batchId, String fileIndex) {
        Blob blob = null;
        Batch batch = this.getBatch(batchId);
        if (batch != null) {
            blob = batch.getBlob(fileIndex);
        }
        return blob;
    }

    @Override
    public List<BatchFileEntry> getFileEntries(String batchId) {
        Batch batch = this.getBatch(batchId);
        if (batch == null) {
            return null;
        }
        return batch.getFileEntries();
    }

    @Override
    public BatchFileEntry getFileEntry(String batchId, String fileIndex) {
        Batch batch = this.getBatch(batchId);
        if (batch == null) {
            return null;
        }
        return batch.getFileEntry(fileIndex);
    }

    @Override
    public void clean(String batchId) {
        Batch batch = this.getBatch(batchId);
        if (batch != null) {
            batch.clean();
        }
    }

    @Override
    public Object execute(String batchId, String chainOrOperationId, CoreSession session, Map<String, Object> contextParams, Map<String, Object> operationParams) {
        List<Blob> blobs = this.getBlobs(batchId, this.getUploadWaitTimeout());
        if (blobs == null) {
            String message = String.format("Unable to find batch associated with id '%s'", batchId);
            log.error(message);
            throw new NuxeoException(message);
        }
        return this.execute(new BlobList(blobs), chainOrOperationId, session, contextParams, operationParams);
    }

    @Override
    public Object execute(String batchId, String fileIndex, String chainOrOperationId, CoreSession session, Map<String, Object> contextParams, Map<String, Object> operationParams) {
        Blob blob = this.getBlob(batchId, fileIndex, this.getUploadWaitTimeout());
        if (blob == null) {
            String message = String.format("Unable to find batch associated with id '%s' or file associated with index '%s'", batchId, fileIndex);
            log.error(message);
            throw new NuxeoException(message);
        }
        return this.execute(blob, chainOrOperationId, session, contextParams, operationParams);
    }

    protected Object execute(Object blobInput, String chainOrOperationId, CoreSession session, Map<String, Object> contextParams, Map<String, Object> operationParams) {
        Object object;
        if (contextParams == null) {
            contextParams = new HashMap<String, Object>();
        }
        if (operationParams == null) {
            operationParams = new HashMap<String, Object>();
        }
        OperationContext ctx = new OperationContext(session);
        try {
            NuxeoPrincipal principal;
            AutomationServer server = (AutomationServer)Framework.getService(AutomationServer.class);
            RestBinding binding = server.getOperationBinding(chainOrOperationId);
            if (binding != null && binding.isAdministrator && !(principal = ctx.getPrincipal()).isAdministrator()) {
                String message = "Not allowed. You must be administrator to use this operation";
                log.error(message);
                throw new WebSecurityException(message);
            }
            ctx.setInput(blobInput);
            ctx.putAll(contextParams);
            AutomationService as = (AutomationService)Framework.getService(AutomationService.class);
            object = as.run(ctx, chainOrOperationId, operationParams);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ctx.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (OperationException e) {
                log.error("Error while executing automation batch ", (Throwable)e);
                throw new NuxeoException((Throwable)e);
            }
        }
        ctx.close();
        return object;
    }

    protected int getUploadWaitTimeout() {
        String t = Framework.getProperty((String)"org.nuxeo.batch.upload.wait.timeout", (String)"5");
        try {
            return Integer.parseInt(t);
        }
        catch (NumberFormatException e) {
            log.error("Wrong number format for upload wait timeout property", (Throwable)e);
            return 5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeAndClean(String batchId, String chainOrOperationId, CoreSession session, Map<String, Object> contextParams, Map<String, Object> operationParams) {
        try {
            Object object = this.execute(batchId, chainOrOperationId, session, contextParams, operationParams);
            return object;
        }
        finally {
            this.clean(batchId);
        }
    }

    @Override
    public boolean removeFileEntry(String batchId, String filedIdx) {
        Batch batch = this.getBatch(batchId);
        return batch != null && batch.removeFileEntry(filedIdx);
    }

    static {
        ComplexTypeJSONDecoder.registerBlobDecoder((JSONBlobDecoder)new JSONBatchBlobDecoder());
    }
}

