/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.test;

import com.google.inject.Binder;
import com.google.inject.Scopes;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.jaxrs.impl.HttpAutomationClient;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RunnerFeature;

public class RemoteAutomationServerFeature
implements RunnerFeature {
    protected static final Log log = LogFactory.getLog(RemoteAutomationServerFeature.class);
    protected static final String TEST_AUTOMATION_URL = "TEST_AUTOMATION_URL";
    protected HttpAutomationClient client;
    protected Session session;
    protected String automationUrl = System.getenv("TEST_AUTOMATION_URL");

    public RemoteAutomationServerFeature() {
        if (this.automationUrl == null) {
            this.automationUrl = "http://localhost:8080/nuxeo/site/automation";
            log.info((Object)("Could not find TEST_AUTOMATION_URL environment variable: fallback to: " + this.automationUrl));
        } else {
            log.info((Object)("Testing against: " + this.automationUrl));
        }
    }

    public void afterRun(FeaturesRunner runner) {
        if (this.client != null) {
            this.client.shutdown();
            this.client = null;
            this.session = null;
        }
    }

    public void configure(FeaturesRunner runner, Binder binder) {
        binder.bind(HttpAutomationClient.class).toProvider(() -> {
            if (this.client == null) {
                this.client = new HttpAutomationClient(this.automationUrl);
            }
            return this.client;
        }).in(Scopes.SINGLETON);
        binder.bind(Session.class).toProvider(() -> {
            if (this.client == null) {
                this.client = new HttpAutomationClient(this.automationUrl);
            }
            if (this.session == null) {
                try {
                    this.session = this.client.getSession("Administrator", "Administrator");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.session;
        }).in(Scopes.SINGLETON);
    }
}

