/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.test;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.AbstractHttpMessage;
import org.nuxeo.ecm.automation.test.HttpAutomationRequest;
import org.nuxeo.ecm.core.api.NuxeoException;

public class HttpAutomationSession {
    protected final CloseableHttpClient client;
    protected final String baseURL;
    protected boolean async;
    protected String username;
    protected String password;
    protected Map<String, String> authHeaders;

    public HttpAutomationSession(CloseableHttpClient client, String baseURL) {
        this.client = client;
        this.baseURL = baseURL;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public HttpAutomationRequest newRequest() {
        return new HttpAutomationRequest(this, null);
    }

    public HttpAutomationRequest newRequest(String operationId) {
        return new HttpAutomationRequest(this, operationId);
    }

    protected void addAuthentication(AbstractHttpMessage request) {
        if (this.username != null && this.password != null) {
            String info = this.username + ":" + this.password;
            String authorization = "Basic " + Base64.encodeBase64String((byte[])info.getBytes(StandardCharsets.UTF_8));
            request.setHeader("Authorization", authorization);
        } else if (this.authHeaders != null) {
            this.authHeaders.forEach((arg_0, arg_1) -> ((AbstractHttpMessage)request).setHeader(arg_0, arg_1));
        } else {
            throw new NuxeoException("Missing auth");
        }
    }

    public void login(String username, String password) throws IOException {
        this.username = username;
        this.password = password;
        this.login(200);
    }

    public String login(Map<String, String> authHeaders) throws IOException {
        return this.login(authHeaders, 200);
    }

    public String login(Map<String, String> authHeaders, int expectedStatusCode) throws IOException {
        this.authHeaders = authHeaders;
        return this.login(expectedStatusCode);
    }

    protected String login(int expectedStatusCode) throws IOException {
        return this.newRequest().login(expectedStatusCode);
    }

    public String propertyMapToString(Map<String, Object> map) {
        StringBuilder properties = new StringBuilder();
        map.forEach((k, v) -> properties.append((String)k).append('=').append(v).append('\n'));
        return properties.toString();
    }
}

