/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.test;

import com.google.inject.Binder;
import com.google.inject.Provider;
import com.google.inject.Scope;
import org.junit.runners.model.FrameworkMethod;
import org.nuxeo.ecm.automation.OperationCallback;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.AutomationCoreFeature;
import org.nuxeo.ecm.automation.core.trace.TracerFactory;
import org.nuxeo.ecm.automation.test.AutomationScope;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.platform.test.PlatformFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RunnerFeature;

@Features(value={PlatformFeature.class, AutomationCoreFeature.class})
@Deploys(value={@Deploy(value={"org.nuxeo.ecm.actions"}), @Deploy(value={"org.nuxeo.ecm.automation.features"}), @Deploy(value={"org.nuxeo.ecm.automation.scripting"}), @Deploy(value={"org.nuxeo.ecm.platform.query.api"}), @Deploy(value={"org.nuxeo.runtime.management"})})
public class AutomationFeature
implements RunnerFeature {
    protected final OperationContextProvider contextProvider = new OperationContextProvider();
    protected final TracerProvider tracerProvider = new TracerProvider();
    protected OperationContext context;
    protected TracerFactory tracerFactory;
    protected OperationCallback tracer;
    protected CoreFeature coreFeature;

    protected OperationContext getContext() {
        if (this.context == null) {
            CoreSession session = this.coreFeature.getCoreSession();
            this.context = new OperationContext(session);
            if (this.tracer != null) {
                this.context.setCallback(this.tracer);
            }
        }
        return this.context;
    }

    protected OperationCallback getTracer() {
        if (this.tracer == null) {
            this.tracer = this.tracerFactory.newTracer();
            if (this.context != null) {
                this.context.setCallback(this.tracer);
            }
        }
        return this.tracer;
    }

    public void configure(FeaturesRunner runner, Binder binder) {
        binder.bind(OperationContext.class).toProvider((Provider)this.contextProvider).in((Scope)AutomationScope.INSTANCE);
        binder.bind(OperationCallback.class).toProvider((Provider)this.tracerProvider).in((Scope)AutomationScope.INSTANCE);
        this.coreFeature = (CoreFeature)runner.getFeature(CoreFeature.class);
        this.tracerFactory = (TracerFactory)Framework.getService(TracerFactory.class);
    }

    public void beforeSetup(FeaturesRunner runner, FrameworkMethod method, Object test) {
        AutomationScope.INSTANCE.enter();
    }

    public void afterTeardown(FeaturesRunner runner, FrameworkMethod method, Object test) {
        AutomationScope.INSTANCE.exit();
        if (this.context != null) {
            this.context.close();
        }
        this.context = null;
        this.tracer = null;
        this.tracerFactory.clearTraces();
    }

    class TracerProvider
    implements Provider<OperationCallback> {
        TracerProvider() {
        }

        public OperationCallback get() {
            return AutomationFeature.this.getTracer();
        }
    }

    public class OperationContextProvider
    implements Provider<OperationContext> {
        public OperationContext get() {
            return AutomationFeature.this.getContext();
        }
    }
}

