/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.test;

import java.io.IOException;
import java.time.Duration;
import java.util.function.Supplier;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.nuxeo.ecm.automation.test.HttpAutomationSession;
import org.nuxeo.ecm.core.api.NuxeoException;

public class HttpAutomationClient {
    protected static final Duration TIMEOUT = Duration.ofSeconds(60L);
    protected final CloseableHttpClient client;
    protected final Supplier<String> baseUrlSupplier;

    public HttpAutomationClient(Supplier<String> baseUrlSupplier) {
        this.baseUrlSupplier = baseUrlSupplier;
        int timeoutMillis = (int)TIMEOUT.toMillis();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeoutMillis).setConnectionRequestTimeout(timeoutMillis).setSocketTimeout(timeoutMillis).build();
        this.client = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
    }

    public void shutdown() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    public HttpAutomationSession getSession() throws IOException {
        String url = this.baseUrlSupplier.get();
        return new HttpAutomationSession(this.client, url);
    }

    public HttpAutomationSession getSession(String username, String password) throws IOException {
        HttpAutomationSession session = this.getSession();
        session.login(username, password);
        return session;
    }
}

