/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.test;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.test.EmbeddedAutomationServerFeature;
import org.nuxeo.ecm.automation.test.HttpAutomationClient;
import org.nuxeo.ecm.automation.test.HttpAutomationSession;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.bulk.CoreBulkFeature;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.TransactionalFeature;

@RunWith(value=FeaturesRunner.class)
@Features(value={EmbeddedAutomationServerFeature.class, CoreBulkFeature.class})
@Deploys(value={@Deploy(value={"org.nuxeo.ecm.automation.test"}), @Deploy(value={"org.nuxeo.ecm.automation.test:operation-contrib.xml"}), @Deploy(value={"org.nuxeo.ecm.automation.test:test-bindings.xml"}), @Deploy(value={"org.nuxeo.ecm.automation.test.test:test-page-provider.xml"}), @Deploy(value={"org.nuxeo.ecm.automation.test.test:test-expose-blob-action.xml"})})
@RepositoryConfig(cleanup=Granularity.METHOD)
public class AsyncOperationAdapterTest {
    public static final String VOID_OPERATION = "X-NXVoidOperation";
    protected static final ObjectMapper MAPPER = new ObjectMapper();
    @Inject
    protected HttpAutomationClient automationClient;
    @Inject
    protected HttpAutomationSession session;
    protected HttpAutomationSession async;
    @Inject
    public TransactionalFeature txFeature;

    public String getDocRef(JsonNode node) {
        return "doc:" + node.get("uid").asText();
    }

    public String getTitle(JsonNode node) {
        return node.get("title").asText();
    }

    public String getPath(JsonNode node) {
        return node.get("path").asText();
    }

    @Before
    public void setUp() throws IOException {
        this.async = this.automationClient.getSession("Administrator", "Administrator");
        this.async.setAsync(true);
    }

    @Test
    public void testAsyncOperation() throws Exception {
        boolean b = this.async.newRequest("TestReturn").setInput((Object)Boolean.TRUE).executeReturningBooleanEntity();
        Assert.assertTrue((boolean)b);
        JsonNode node = this.async.newRequest("Repository.GetDocument").set("value", (Object)"/").executeReturningDocument();
        Assert.assertNotNull((Object)node);
        List nodes = this.async.newRequest("Repository.Query").set("query", (Object)"SELECT * from Document").executeReturningDocuments();
        Assert.assertNotNull((Object)nodes);
        JsonNode root = this.session.newRequest("Repository.GetDocument").set("value", (Object)"/").executeReturningDocument();
        JsonNode folder = this.session.newRequest("Document.Create").setInput((Object)root).set("type", (Object)"Folder").set("name", (Object)"asyncTest").executeReturningDocument();
        JsonNode file = this.session.newRequest("Document.Create").setInput((Object)folder).set("type", (Object)"File").set("name", (Object)"blobs").executeReturningDocument();
        Blob fb = Blobs.createBlob((String)"<doc>mydoc1</doc>", (String)"text/xml", null, (String)"file.xml");
        this.session.newRequest("Blob.AttachOnDocument").setHeader(VOID_OPERATION, "true").setInput((Object)fb).set("document", (Object)this.getPath(file)).execute();
        Blob blob = this.async.newRequest("Document.GetBlob").setInput((Object)this.getDocRef(file)).executeReturningBlob();
        Assert.assertNotNull((Object)blob);
    }

    @Test
    public void testAsyncChain() throws Exception {
        JsonNode folder = this.session.newRequest("Document.Create").setInput((Object)"doc:/").set("type", (Object)"Folder").set("name", (Object)"chainTest").executeReturningDocument();
        JsonNode doc = this.async.newRequest("testchain").setInput((Object)folder).executeReturningDocument();
        TestCase.assertEquals((String)"/chainTest/chain.doc", (String)this.getPath(doc));
        TestCase.assertEquals((String)"Note", (String)doc.get("type").asText());
        JsonNode file = this.session.newRequest("Document.Create").setInput((Object)folder).set("type", (Object)"File").set("name", (Object)"file").executeReturningDocument();
        Blob fb = Blobs.createBlob((String)"Foo", (String)"text/plain", null, (String)"file.txt");
        this.session.newRequest("Blob.AttachOnDocument").setHeader(VOID_OPERATION, "true").setInput((Object)fb).set("document", (Object)this.getPath(file)).execute();
        Blob res = this.async.newRequest("testFetchDocumentChain").setInput((Object)file).executeReturningBlob();
        Assert.assertNotNull((Object)res);
        TestCase.assertEquals((String)fb.getFilename(), (String)res.getFilename());
    }

    @Test
    public void testError() throws Exception {
        String r = this.session.newRequest("Test.Exit").setInput((Object)"Error").executeReturningStringEntity();
        TestCase.assertEquals((String)"Error", (String)r);
        String error = this.async.newRequest("Test.Exit").set("error", (Object)true).set("rollback", (Object)true).executeReturningExceptionEntity(500);
        TestCase.assertEquals((String)"termination error", (String)error);
    }

    @Test
    public void testAsyncBulkAction() throws Exception {
        this.session.newRequest("Document.Create").setInput((Object)"doc:/").set("type", (Object)"Folder").set("name", (Object)"test").executeReturningDocument();
        HashMap<String, String> automationParams = new HashMap<String, String>();
        automationParams.put("properties", "dc:title=foo");
        HashMap<String, Object> actionParams = new HashMap<String, Object>();
        actionParams.put("operationId", "Document.Update");
        actionParams.put("parameters", automationParams);
        JsonNode r = this.async.newRequest("Bulk.RunAction").set("action", (Object)"automation").set("query", (Object)"SELECT * FROM Folder").set("bucketSize", (Object)"10").set("batchSize", (Object)"5").set("parameters", (Object)MAPPER.writeValueAsString(actionParams)).execute();
        Assert.assertNotNull((Object)r);
        this.txFeature.nextTransaction();
        JsonNode folder = this.session.newRequest("Repository.GetDocument").set("value", (Object)"/test").executeReturningDocument();
        TestCase.assertEquals((String)"foo", (String)this.getTitle(folder));
    }

    @Test
    public void testFailingBulkAction() throws Exception {
        String result = this.async.newRequest("Bulk.RunAction").set("action", (Object)"automation").set("query", (Object)"SELECT * FROM Folder").set("bucketSize", (Object)"10").set("batchSize", (Object)"5").set("parameters", (Object)"{}").executeReturningExceptionEntity(500);
        Assert.assertTrue((boolean)result.startsWith("Unknown operation id null in command: org.nuxeo.ecm.core.bulk.message.BulkCommand"));
    }

    @Test
    public void testAsyncExposeBlob() throws Exception {
        JsonNode r = this.async.newRequest("Bulk.RunAction").set("action", (Object)"dummyExposeBlob").set("query", (Object)"SELECT * FROM Folder").execute();
        Assert.assertNotNull((Object)r);
        Assert.assertNotNull((Object)r.get("url"));
        Assert.assertTrue((boolean)new URI(r.get("url").asText()).isAbsolute());
    }

    @Test
    public void testAsyncBulkActionWithPPWhereClause() throws IOException {
        this.testAsyncBulkActionWithPP("QuickFilterPageProvider");
    }

    @Test
    public void testAsyncBulkActionWithPPPattern() throws IOException {
        this.testAsyncBulkActionWithPP("PageProvider");
    }

    protected void testAsyncBulkActionWithPP(String pageProviderName) throws IOException {
        this.session.newRequest("Document.Create").setInput((Object)"doc:/").set("type", (Object)"Folder").set("name", (Object)"test").executeReturningDocument();
        this.session.newRequest("Document.Create").setInput((Object)"doc:/test").set("type", (Object)"File").set("name", (Object)"file").executeReturningDocument();
        HashMap<String, String> automationParams = new HashMap<String, String>();
        automationParams.put("properties", "dc:title=foo");
        HashMap<String, Object> actionParams = new HashMap<String, Object>();
        actionParams.put("operationId", "Document.Update");
        actionParams.put("parameters", automationParams);
        JsonNode r = this.async.newRequest("Bulk.RunAction").set("action", (Object)"automation").set("providerName", (Object)pageProviderName).set("quickFilters", (Object)"FileOnly").set("bucketSize", (Object)"10").set("batchSize", (Object)"5").set("parameters", (Object)MAPPER.writeValueAsString(actionParams)).execute();
        Assert.assertNotNull((Object)r);
        this.txFeature.nextTransaction();
        JsonNode folder = this.session.newRequest("Repository.GetDocument").set("value", (Object)"/test").executeReturningDocument();
        JsonNode file = this.session.newRequest("Repository.GetDocument").set("value", (Object)"/test/file").executeReturningDocument();
        TestCase.assertEquals((String)"test", (String)this.getTitle(folder));
        TestCase.assertEquals((String)"foo", (String)this.getTitle(file));
    }
}

