/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.test;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;
import org.mockito.verification.VerificationMode;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.trace.Call;
import org.nuxeo.ecm.automation.core.trace.Trace;
import org.nuxeo.ecm.automation.core.trace.TracerFactory;
import org.nuxeo.ecm.automation.server.test.DummyOperation;
import org.nuxeo.ecm.automation.test.AutomationFeature;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={AutomationFeature.class})
@Deploys(value={@Deploy(value={"org.nuxeo.ecm.automation.test"}), @Deploy(value={"org.nuxeo.ecm.automation.test:test-bindings.xml"})})
public class CanTraceChainsTest {
    @Inject
    AutomationService service;
    @Inject
    OperationContext context;
    @Inject
    CoreSession session;
    @Inject
    TracerFactory factory;
    DocumentModel src;

    @Before
    public void setup() throws OperationException {
        this.service.putOperation(DummyOperation.class);
        this.src = this.session.createDocumentModel("/", "src", "Workspace");
        this.src.setPropertyValue("dc:title", (Serializable)((Object)"Source"));
        this.src = this.session.createDocument(this.src);
        this.session.save();
        if (!this.factory.getRecordingState()) {
            this.factory.toggleRecording();
        }
    }

    @After
    public void teardown() {
        this.service.removeOperation(DummyOperation.class);
    }

    @Test
    public void testSimpleChainTrace() throws Exception {
        OperationChain chain = new OperationChain("testChain");
        chain.add("Dummy").set("Dummy", (Object)"Dummy");
        chain.add("Dummy");
        chain.add("Dummy");
        this.context.setInput((Object)"Dummy");
        this.context.put("Dummy", (Object)"Dummy");
        this.service.run(this.context, chain);
        Trace trace = this.factory.getTrace("testChain");
        Assert.assertNull((Object)((Object)trace.getError()));
        Assert.assertEquals((Object)"Dummy", (Object)trace.getOutput());
        List calls = trace.getCalls();
        Assert.assertEquals((long)3L, (long)calls.size());
        Call firstCall = (Call)calls.get(0);
        Assert.assertEquals((Object)"Dummy", (Object)firstCall.getType().getId());
        Assert.assertEquals((Object)"Dummy", firstCall.getVariables().get("Dummy"));
        Assert.assertEquals((Object)"Dummy", firstCall.getParameters().get("Dummy"));
        this.factory.toggleRecording();
        calls = trace.getCalls();
        Assert.assertEquals((long)3L, (long)calls.size());
    }

    @Test
    public void testSubchainsTrace() throws Exception {
        String chainid = "traceSubchains";
        OperationChain chain = new OperationChain("parentChain");
        OperationParameters runOnListParams = new OperationParameters("RunOperationOnList");
        runOnListParams.set("list", (Object)"list");
        runOnListParams.set("id", (Object)"traceSubchains");
        chain.add(runOnListParams);
        this.context.setInput((Object)this.src);
        this.context.put("list", Arrays.asList("one", "two"));
        this.service.run(this.context, chain);
        Trace trace = this.factory.getTrace("parentChain");
        List calls = trace.getCalls();
        Assert.assertEquals((long)1L, (long)calls.size());
        List nested = ((Call)calls.get(0)).getNested();
        Assert.assertEquals((long)2L, (long)nested.size());
        Assert.assertEquals(((Call)((Trace)nested.get(0)).getCalls().get(0)).getVariables().get("item"), (Object)"one");
        Assert.assertEquals(((Call)((Trace)nested.get(1)).getCalls().get(0)).getVariables().get("item"), (Object)"two");
    }

    @Test
    public void testOperationTrace() throws Exception {
        HashMap<String, DocumentModel> parameters = new HashMap<String, DocumentModel>();
        parameters.put("value", this.src);
        this.service.run(this.context, "Repository.GetDocument", parameters);
        Trace trace = this.factory.getTrace("Repository.GetDocument");
        List calls = trace.getCalls();
        Assert.assertEquals((long)1L, (long)calls.size());
    }

    @Test
    public void testTraceMvelExpression() throws Exception {
        this.context.setInput((Object)this.src);
        this.service.run(this.context, "testChainTrace");
        Trace trace = this.factory.getTrace("testChainTrace");
        Assert.assertEquals((Object)"chain.doc", (Object)((Call.ExpressionParameter)((Call)trace.getCalls().get(2)).getParameters().get("name")).getParameterValue());
        Assert.assertEquals((Object)"name", (Object)((Call.ExpressionParameter)((Call)trace.getCalls().get(2)).getParameters().get("name")).getParameterId());
    }

    @Test
    public void canKeepSubContextValuesWithTraces() throws Exception {
        try (OperationContext ctx = new OperationContext(this.session);){
            ArrayList<String> users = new ArrayList<String>();
            users.add("foo");
            users.add("bar");
            users.add("baz");
            users.add("bum");
            ctx.put("users", users);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("list", "users");
            parameters.put("id", "mvelSubChain");
            parameters.put("isolate", "false");
            this.service.run(ctx, "RunOperationOnList", parameters);
            Assert.assertEquals((Object)"foo", (Object)ctx.get((Object)"foo"));
            Assert.assertEquals((Object)"bar", (Object)ctx.get((Object)"bar"));
            Assert.assertEquals((Object)"baz", (Object)ctx.get((Object)"baz"));
            Assert.assertEquals((Object)"bum", (Object)ctx.get((Object)"bum"));
        }
    }

    @Test
    public void ensureTraceWithErrorIsPrinted() {
        TracerFactory tracerFactory = new TracerFactory();
        Trace mockedTrace = (Trace)Mockito.mock(Trace.class);
        OperationType mockedOpeType = (OperationType)Mockito.mock(OperationType.class);
        Mockito.when((Object)mockedOpeType.getId()).thenReturn((Object)"fooid");
        Whitebox.setInternalState((Object)mockedTrace, (String)"chain", (Object)mockedOpeType);
        tracerFactory.onTrace(mockedTrace);
        ((Trace)Mockito.verify((Object)mockedTrace, (VerificationMode)Mockito.times((int)0))).print(Matchers.anyBoolean());
        Whitebox.setInternalState((Object)mockedTrace, (String)"error", (Object)((Object)new OperationException("foo")));
        tracerFactory.onTrace(mockedTrace);
        ((Trace)Mockito.verify((Object)mockedTrace, (VerificationMode)Mockito.atLeastOnce())).print(Matchers.anyBoolean());
    }

    @Test
    public void canEnableTracesViaOperation() throws Exception {
        if (this.factory.getRecordingState()) {
            this.factory.toggleRecording();
        }
        Assert.assertFalse((boolean)this.factory.getRecordingState());
        this.service.run(this.context, "Traces.ToggleRecording");
        Assert.assertTrue((boolean)this.factory.getRecordingState());
    }
}

