/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.test;

import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.server.AutomationServer;
import org.nuxeo.ecm.automation.server.RestBinding;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.webengine.test.WebEngineFeatureCore;
import org.nuxeo.runtime.logging.DeprecationLogger;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.HotDeployer;
import org.nuxeo.runtime.test.runner.LogCaptureFeature;

@RunWith(value=FeaturesRunner.class)
@Features(value={CoreFeature.class, WebEngineFeatureCore.class, LogCaptureFeature.class})
@Deploys(value={@Deploy(value={"org.nuxeo.ecm.automation.core"}), @Deploy(value={"org.nuxeo.ecm.automation.io"}), @Deploy(value={"org.nuxeo.ecm.automation.server"})})
public class ContributionTest {
    public static final int DEFAULT_BINDINGS = 8;
    @Inject
    AutomationServer server;
    @Inject
    protected HotDeployer hotDeployer;
    @Inject
    protected LogCaptureFeature.Result logCaptureResult;

    @Test
    @LogCaptureFeature.FilterOn(loggerClass=DeprecationLogger.class, logLevel="WARN")
    public void testContribution() throws Exception {
        this.hotDeployer.deploy(new String[]{"org.nuxeo.ecm.automation.server:test-bindings.xml"});
        Assert.assertEquals((long)9L, (long)this.server.getBindings().length);
        RestBinding binding = this.server.getChainBinding("principals");
        Assert.assertNull((Object)binding);
        List caughtEvents = this.logCaptureResult.getCaughtEventMessages();
        Assert.assertEquals((long)1L, (long)caughtEvents.size());
        Assert.assertEquals((Object)"Since version 11.5: Usage of \"disabled\" attribute on RestBinding contribution 'Chain.principals', in extension 'org.nuxeo.ecm.automation.server.test-bindings#bindings', is deprecated: use \"enable\" attribute instead.", caughtEvents.get(0));
        binding = this.server.getChainBinding("audit");
        Assert.assertFalse((boolean)binding.isDisabled);
        Assert.assertTrue((boolean)binding.isSecure);
        Assert.assertTrue((boolean)binding.isAdministrator);
        Assert.assertEquals((long)1L, (long)binding.groups.length);
        Assert.assertEquals((Object)"members", (Object)binding.groups[0]);
    }
}

