/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.test;

import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.test.EmbeddedAutomationServerFeature;
import org.nuxeo.ecm.automation.test.HttpAutomationSession;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={EmbeddedAutomationServerFeature.class})
@Deploy(value={"org.nuxeo.ecm.automation.test.test:test-page-provider.xml"})
public class TestDocumentPageProviderOperation {
    @Inject
    protected HttpAutomationSession session;

    @Test
    public void testDocumentPageProviderOperation() throws IOException {
        List documents = this.session.newRequest("Repository.PageProvider").set("providerName", (Object)"PageProvider").executeReturningDocuments();
        Assert.assertNotNull((Object)documents);
        Assert.assertEquals((long)2L, (long)documents.size());
        documents = this.session.newRequest("Repository.PageProvider").set("providerName", (Object)"PageProvider").set("quickFilters", (Object)"SectionRoot").executeReturningDocuments();
        Assert.assertNotNull((Object)documents);
        Assert.assertEquals((long)1L, (long)documents.size());
    }

    @Test
    public void testDocumentPageProviderOperationWithOffset() throws IOException {
        List documents = this.session.newRequest("Repository.PageProvider").set("providerName", (Object)"PageProvider").executeReturningDocuments();
        Assert.assertNotNull((Object)documents);
        int offset = 1;
        List documentsOffset = this.session.newRequest("Repository.PageProvider").set("providerName", (Object)"PageProvider").set("offset", (Object)offset).executeReturningDocuments();
        Assert.assertNotNull((Object)documentsOffset);
        Assert.assertEquals(documents.get(offset), documentsOffset.get(0));
    }
}

