/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.test;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.test.EmbeddedAutomationServerFeature;
import org.nuxeo.ecm.automation.test.HttpAutomationSession;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={EmbeddedAutomationServerFeature.class})
@Deploys(value={@Deploy(value={"org.nuxeo.ecm.automation.scripting"}), @Deploy(value={"org.nuxeo.ecm.automation.test.test:operation-contrib.xml"}), @Deploy(value={"org.nuxeo.ecm.automation.test.test:chain-scripting-operation-contrib.xml"})})
@RepositoryConfig(cleanup=Granularity.METHOD)
public class TestRemoteAutomationScript {
    @Inject
    HttpAutomationSession session;
    @Inject
    AutomationService service;

    protected List<JsonNode> getDocuments() throws IOException {
        JsonNode root = this.session.newRequest("Repository.GetDocument").set("value", (Object)"/").executeReturningDocument();
        JsonNode simple = this.session.newRequest("Document.Create").setInput((Object)root).set("type", (Object)"File").set("name", (Object)"Simple").set("properties", (Object)"dc:title=Simple\n").executeReturningDocument();
        return Arrays.asList(simple, root);
    }

    @Test
    public void canHandleDocumentSentRemotely() throws IOException {
        JsonNode document = this.session.newRequest("javascript.RemoteScriptWithDoc").setInput((Object)this.getDocuments().get(0)).executeReturningDocument();
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((Object)"Simple", (Object)document.get("title").asText());
    }

    @Test
    public void canHandleDocumentsSentRemotely() throws IOException {
        List documents = this.session.newRequest("javascript.RemoteScriptWithDocs").setInput(this.getDocuments()).executeReturningDocuments();
        Assert.assertNotNull((Object)documents);
        Assert.assertEquals((long)2L, (long)documents.size());
        Assert.assertEquals((Object)"Simple", (Object)((JsonNode)documents.get(0)).get("title").asText());
    }

    @Test
    public void testRemoteChainWithScriptingOp() throws IOException {
        JsonNode doc = this.session.newRequest("testChain2").setInput((Object)"doc:/").executeReturningDocument();
        Assert.assertNotNull((Object)doc);
    }

    @Test
    public void canCallHtmlEscapeViaJS() throws IOException {
        String escaped = this.session.newRequest("javascript.testHtmlEscape").setInput((Object)" cou&cou ").executeReturningStringEntity();
        Assert.assertNotNull((Object)escaped);
        Assert.assertEquals((Object)" cou&amp;cou ", (Object)escaped);
    }

    @Test
    public void canCallNxqlEscapeViaJS() throws IOException {
        String escaped = this.session.newRequest("javascript.testNxqlEscape").setInput((Object)" \n ").executeReturningStringEntity();
        Assert.assertNotNull((Object)escaped);
        Assert.assertEquals((Object)" \\n ", (Object)escaped);
    }
}

