/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.test;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.test.EmbeddedAutomationServerFeature;
import org.nuxeo.ecm.automation.test.HttpAutomationSession;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.io.registry.MarshallerHelper;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={CoreFeature.class, EmbeddedAutomationServerFeature.class})
@Deploy(value={"org.nuxeo.ecm.automation.test.test:operation-contrib.xml"})
public class TestUpdateMailOperation {
    @Inject
    protected CoreSession coreSession;
    @Inject
    protected HttpAutomationSession session;

    @Test
    public void testOperation() throws IOException {
        JsonNode updatedUsers = this.session.newRequest("updateMail").set("users", List.of(this.coreSession.getPrincipal().getName())).execute();
        Assert.assertNotNull((Object)updatedUsers);
        List users = MarshallerHelper.jsonToList(NuxeoPrincipal.class, (String)updatedUsers.toString(), (RenderingContext)RenderingContext.CtxBuilder.get());
        Assert.assertEquals((Object)"test@nuxeo.com", (Object)((NuxeoPrincipal)users.get(0)).getEmail());
    }
}

