/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.drivers;

import java.io.File;
import java.util.Arrays;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.functionaltests.drivers.DriverProvider;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public class ChromeDriverProvider
implements DriverProvider {
    private static final Log log = LogFactory.getLog(DriverProvider.class);
    public static final String CHROME_DRIVER_DEFAULT_PATH_LINUX = "/usr/bin/chromedriver";
    public static final String CHROME_DRIVER_DEFAULT_PATH_MAC = "/Applications/chromedriver";
    public static final String CHROME_DRIVER_DEFAULT_PATH_WINVISTA = SystemUtils.getUserHome().getPath() + "\\AppData\\Local\\Google\\Chrome\\Application\\chromedriver.exe";
    public static final String CHROME_DRIVER_DEFAULT_PATH_WINXP = SystemUtils.getUserHome().getPath() + "\\Local Settings\\Application Data\\Google\\Chrome\\Application\\chromedriver.exe";
    public static final String CHROME_DRIVER_DEFAULT_EXECUTABLE_NAME = "chromedriver";
    public static final String CHROME_DRIVER_WINDOWS_EXECUTABLE_NAME = "chromedriver.exe";
    public static final String SYSPROP_CHROME_DRIVER_PATH = "webdriver.chrome.driver";
    protected ChromeDriver driver;

    @Override
    public RemoteWebDriver init(DesiredCapabilities dc) throws Exception {
        if (System.getProperty(SYSPROP_CHROME_DRIVER_PATH) == null) {
            String chromeDriverDefaultPath = null;
            String chromeDriverExecutableName = CHROME_DRIVER_DEFAULT_EXECUTABLE_NAME;
            if (SystemUtils.IS_OS_LINUX) {
                chromeDriverDefaultPath = CHROME_DRIVER_DEFAULT_PATH_LINUX;
            } else if (SystemUtils.IS_OS_MAC) {
                chromeDriverDefaultPath = CHROME_DRIVER_DEFAULT_PATH_MAC;
            } else if (SystemUtils.IS_OS_WINDOWS_XP) {
                chromeDriverDefaultPath = CHROME_DRIVER_DEFAULT_PATH_WINXP;
                chromeDriverExecutableName = CHROME_DRIVER_WINDOWS_EXECUTABLE_NAME;
            } else if (SystemUtils.IS_OS_WINDOWS_VISTA || SystemUtils.IS_OS_WINDOWS) {
                chromeDriverDefaultPath = CHROME_DRIVER_DEFAULT_PATH_WINVISTA;
                chromeDriverExecutableName = CHROME_DRIVER_WINDOWS_EXECUTABLE_NAME;
            }
            if (chromeDriverDefaultPath != null && new File(chromeDriverDefaultPath).exists()) {
                log.warn((Object)String.format("Missing property %s but found %s. Using it...", SYSPROP_CHROME_DRIVER_PATH, chromeDriverDefaultPath));
                System.setProperty(SYSPROP_CHROME_DRIVER_PATH, chromeDriverDefaultPath);
            } else {
                File chromeDriverExecutable = ChromeDriverProvider.findExecutableOnPath(chromeDriverExecutableName);
                if (chromeDriverExecutable != null && chromeDriverExecutable.exists()) {
                    log.warn((Object)String.format("Missing property %s but found %s. Using it...", SYSPROP_CHROME_DRIVER_PATH, chromeDriverExecutable.getCanonicalPath()));
                    System.setProperty(SYSPROP_CHROME_DRIVER_PATH, chromeDriverExecutable.getCanonicalPath());
                } else {
                    log.error((Object)String.format("Could not find the Chrome driver looking at %s or system path. Download it from %s and set its path with the System property %s.", chromeDriverDefaultPath, "http://code.google.com/p/chromedriver/downloads/list", SYSPROP_CHROME_DRIVER_PATH));
                }
            }
        }
        ChromeOptions options = new ChromeOptions();
        options.addArguments(Arrays.asList("--ignore-certificate-errors"));
        dc.setCapability("chromeOptions", (Object)options);
        this.driver = new ChromeDriver((Capabilities)dc);
        return this.driver;
    }

    protected static File findExecutableOnPath(String executableName) {
        String systemPath = System.getenv("PATH");
        String[] pathDirs = systemPath.split(File.pathSeparator);
        File fullyQualifiedExecutable = null;
        for (String pathDir : pathDirs) {
            File file = new File(pathDir, executableName);
            if (!file.isFile()) continue;
            fullyQualifiedExecutable = file;
            break;
        }
        return fullyQualifiedExecutable;
    }

    @Override
    public RemoteWebDriver get() {
        return this.driver;
    }

    @Override
    public void quit() {
        if (this.driver != null) {
            this.driver.quit();
            this.driver = null;
        }
    }
}

