/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.forms;

import java.util.List;
import org.nuxeo.functionaltests.JSListRequestManager;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.forms.AbstractWidgetElement;
import org.nuxeo.functionaltests.forms.WidgetElement;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class JSListWidgetElement
extends AbstractWidgetElement {
    private final Display display;

    public JSListWidgetElement(WebDriver driver, String id) {
        this(driver, id, Display.BLOCK_LEFT);
    }

    public JSListWidgetElement(WebDriver driver, String id, Display display) {
        super(driver, id);
        this.display = display;
    }

    protected String getListSubElementSuffix(String subId, int index) {
        return String.format("%s:%s", index, subId);
    }

    public void addNewElement() {
        WebElement addElement = this.getElement(this.id + "_add");
        JSListRequestManager rm = new JSListRequestManager(this.driver);
        rm.begin();
        Locator.waitUntilEnabledAndClick(addElement);
        rm.end();
    }

    public void removeElement(int index) {
        WebElement delElement = this.getRowActions(index).findElement(By.className((String)"deleteBtn"));
        JSListRequestManager rm = new JSListRequestManager(this.driver);
        rm.begin();
        Locator.waitUntilEnabledAndClick(delElement);
        rm.end();
    }

    public void moveUpElement(int index) {
        WebElement moveElement = this.getRowActions(index).findElement(By.className((String)"moveUpBtn"));
        JSListRequestManager rm = new JSListRequestManager(this.driver);
        rm.begin();
        Locator.waitUntilEnabledAndClick(moveElement);
        rm.end();
    }

    public void moveDownElement(int index) {
        WebElement moveElement = this.getRowActions(index).findElement(By.className((String)"moveDownBtn"));
        JSListRequestManager rm = new JSListRequestManager(this.driver);
        rm.begin();
        Locator.waitUntilEnabledAndClick(moveElement);
        rm.end();
    }

    public void waitForSubWidget(String id, int index) {
        this.getSubElement(this.getListSubElementSuffix(id, index), true);
    }

    public WidgetElement getSubWidget(String id, int index) {
        return this.getSubWidget(id, index, false);
    }

    public String getSubWidgetId(String id, int index) {
        return this.getSubWidgetId(id, index, false);
    }

    public WidgetElement getSubWidget(String id, int index, boolean wait) {
        if (wait) {
            this.waitForSubWidget(id, index);
        }
        return this.getWidget(this.getListSubElementSuffix(id, index));
    }

    public String getSubWidgetId(String id, int index, boolean wait) {
        return this.getSubWidget(id, index, wait).getId();
    }

    public <T> T getSubWidget(String id, int index, Class<T> widgetClassToProxy, boolean wait) {
        if (wait) {
            this.waitForSubWidget(id, index);
        }
        return this.getWidget(this.getListSubElementSuffix(id, index), widgetClassToProxy);
    }

    @Override
    public String getMessageValue() {
        return this.getMessageValue("_message");
    }

    protected WebElement getRowActions(int i) {
        if (this.display == Display.TABLE || this.display == Display.INLINE) {
            return this.driver.findElement(By.cssSelector((String)(this.getRowCssSelector(i) + " > .listWidgetActions")));
        }
        return this.driver.findElement(By.cssSelector((String)(this.getRowCssSelector(i) + " .listWidgetActionsTable")));
    }

    public String getSubWidgetMessageValue(String id, int idx) {
        return this.getSubWidgetMessageValue(id, idx, 0);
    }

    public String getSubWidgetMessageValue(String id, int idx, int msgIdx) {
        String subId = id + "_message";
        if (msgIdx != 0) {
            subId = subId + "_" + msgIdx;
        }
        return this.getMessageValue(":" + this.getListSubElementSuffix(subId, idx));
    }

    public List<WebElement> getRows() {
        return this.driver.findElements(By.cssSelector((String)this.getRowsCssSelector()));
    }

    private String getElementCssSelector() {
        return "#" + this.id.replaceAll(":", "\\\\:") + "_panel";
    }

    private String getRowsCssSelector() {
        Object path = this.getElementCssSelector();
        if (this.display == Display.TABLE || this.display == Display.INLINE) {
            path = (String)path + " > table > tbody";
        }
        return (String)path + " > .listItem";
    }

    private String getRowCssSelector(int i) {
        return this.getRowsCssSelector() + ":nth-of-type(" + (i + 1) + ")";
    }

    public static enum Display {
        BLOCK_LEFT,
        BLOCK_TOP,
        TABLE,
        INLINE;

    }
}

