/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages;

import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.nuxeo.functionaltests.pages.DocumentBasePage;
import org.nuxeo.functionaltests.pages.WorkflowHomePage;
import org.nuxeo.functionaltests.pages.profile.ProfilePage;
import org.nuxeo.functionaltests.pages.tabs.SummaryTabSubPage;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class UserHomePage
extends AbstractPage {
    private static final String TASK_XPATH_BASE = ".//table[@class='dataOutput']/tbody/tr[td[normalize-space(text())='%s']]";
    private static final String DOCUMENT_XPATH_BASE = ".//table[@class='dataOutput']/tbody/tr[td/div/a/span[normalize-space(text())='%s']]";
    @FindBy(id="nxw_dashboard_user_tasks")
    WebElement userTasks;
    @FindBy(id="nxw_dashboard_user_workspaces")
    WebElement userWorkspaces;
    @FindBy(id="nxw_dashboard_user_documents")
    WebElement userDocuments;
    @FindBy(id="nxw_dashboard_domain_documents")
    WebElement domainDocuments;
    @FindBy(id="selectDashboardDomain:selectDashboardDomainMenu")
    WebElement selectDomainInput;
    @FindBy(id="selectDashboardDomain:dashboardDomainSubmitButton")
    WebElement selectDomainSubmitButton;

    public UserHomePage(WebDriver driver) {
        super(driver);
    }

    public boolean taskExistsOnUserTasks(String taskName) {
        try {
            return this.getUserTask(taskName).isDisplayed();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public SummaryTabSubPage redirectToTask(String taskTitle) {
        UserHomePage.waitUntilEnabledAndClick(this.userTasks.findElement(By.linkText((String)taskTitle)));
        return this.asPage(SummaryTabSubPage.class);
    }

    public boolean isUserTasksEmpty() {
        return this.userTasks.getText().contains("Your dashboard is empty");
    }

    public WorkflowHomePage getWorkflowHomePage() {
        this.goToTab("nxw_WorkflowHome");
        return this.asPage(WorkflowHomePage.class);
    }

    public UserHomePage goToDashboard() {
        this.goToTab("nxw_Dashboard");
        return this;
    }

    public ProfilePage goToProfile() {
        this.goToTab("nxw_Profile");
        return this.asPage(ProfilePage.class);
    }

    public boolean hasSelectDomainInput() {
        try {
            return this.selectDomainInput.isDisplayed();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public UserHomePage selectDomain(String domainName) {
        this.selectItemInDropDownMenu(this.selectDomainInput, domainName);
        Locator.waitUntilEnabledAndClick(this.selectDomainSubmitButton);
        return this.asPage(UserHomePage.class);
    }

    public boolean hasUserWorkspace(String workspaceName) {
        try {
            return this.getUserWorkspace(workspaceName) != null;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public boolean hasUserDocument(String docName) {
        try {
            return this.getUserDocument(docName) != null;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public boolean hasDomainDocument(String docName) {
        try {
            return this.getDomainDocument(docName) != null;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public DocumentBasePage goToDomainDocument(String docName) {
        Locator.findElementWaitUntilEnabledAndClick(this.getDomainDocument(docName), By.className((String)"documentTitle"));
        return this.asPage(DocumentBasePage.class);
    }

    protected void goToTab(String id) {
        this.clickOnTabIfNotSelected("nxw_homeTabs_panel", id);
    }

    protected WebElement getUserTask(String taskName) {
        String xpath = String.format(TASK_XPATH_BASE, taskName);
        return this.userTasks.findElement(By.xpath((String)xpath));
    }

    protected WebElement getUserWorkspace(String workspaceName) {
        String xpath = String.format(DOCUMENT_XPATH_BASE, workspaceName);
        return this.userWorkspaces.findElement(By.xpath((String)xpath));
    }

    protected WebElement getUserDocument(String docName) {
        String xpath = String.format(DOCUMENT_XPATH_BASE, docName);
        return this.userDocuments.findElement(By.xpath((String)xpath));
    }

    protected WebElement getDomainDocument(String docName) {
        String xpath = String.format(DOCUMENT_XPATH_BASE, docName);
        return this.domainDocuments.findElement(By.xpath((String)xpath));
    }
}

