/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.admincenter;

import org.nuxeo.functionaltests.pages.LoginPage;
import org.nuxeo.functionaltests.pages.admincenter.AdminCenterBasePage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class SystemHomePage
extends AdminCenterBasePage {
    public static final String HOST_SUBTAB = "Host";
    public static final String SETUP_SUBTAB = "Setup";
    private static final int RESTART_TIMEOUT_MINUTES = 10;

    public SystemHomePage(WebDriver driver) {
        super(driver);
    }

    public LoginPage restart() {
        if (!HOST_SUBTAB.equals(this.getSelectedSubTab())) {
            this.selectSubTab(HOST_SUBTAB);
        }
        By restartLocator = By.xpath((String)"//input[@type='submit' and @value='Restart server']");
        SystemHomePage.findElementWaitUntilEnabledAndClick(restartLocator);
        this.findElementWithTimeout(By.id((String)"username"), 600000);
        return this.asPage(LoginPage.class);
    }

    public boolean setConfig(String id, String value) {
        WebElement input;
        if (!SETUP_SUBTAB.equals(this.getSelectedSubTab())) {
            this.selectSubTab(SETUP_SUBTAB);
        }
        if ((input = SystemHomePage.findElementWithTimeout(By.xpath((String)("//td[@id='" + id + "']/input")))) != null) {
            input.sendKeys(new CharSequence[]{value});
            return true;
        }
        return false;
    }

    public String getConfig(String id) {
        WebElement input;
        if (!SETUP_SUBTAB.equals(this.getSelectedSubTab())) {
            this.selectSubTab(SETUP_SUBTAB);
        }
        if ((input = SystemHomePage.findElementWithTimeout(By.xpath((String)("//td[@id='" + id + "']/input")))) != null) {
            return input.getAttribute("value");
        }
        return null;
    }
}

