/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests;

import com.google.common.base.Function;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.nuxeo.functionaltests.AbstractTest;
import org.openqa.selenium.By;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.WebDriverWait;

public class Locator {
    public static final int URLCHANGE_MAX_WAIT = 30;

    public static WebElement findElement(By by) {
        return AbstractTest.driver.findElement(by);
    }

    public static WebElement findElementAndWaitUntilEnabled(By by) throws NotFoundException {
        return Locator.findElementAndWaitUntilEnabled(by, 30000, 10000);
    }

    public static WebElement findElementAndWaitUntilEnabled(By by, int findElementTimeout, int waitUntilEnabledTimeout) throws NotFoundException {
        return Locator.findElementAndWaitUntilEnabled(null, by, findElementTimeout, waitUntilEnabledTimeout);
    }

    public static WebElement findElementAndWaitUntilEnabled(final WebElement parentElement, final By by, final int findElementTimeout, final int waitUntilEnabledTimeout) throws NotFoundException {
        FluentWait<WebDriver> wait = Locator.getFluentWait();
        Function<WebDriver, WebElement> function = new Function<WebDriver, WebElement>(){

            public WebElement apply(WebDriver driver) {
                WebElement element = null;
                try {
                    element = Locator.findElementWithTimeout(by, findElementTimeout, parentElement);
                    Locator.waitUntilEnabled(element, waitUntilEnabledTimeout);
                }
                catch (StaleElementReferenceException sere) {
                    AbstractTest.log.debug((Object)("StaleElementReferenceException: " + sere.getMessage()));
                    return null;
                }
                return element;
            }
        };
        return (WebElement)wait.until((Function)function);
    }

    public static List<WebElement> findElementsWithTimeout(final By by) throws NoSuchElementException {
        FluentWait<WebDriver> wait = Locator.getFluentWait();
        wait.ignoring(NoSuchElementException.class);
        return (List)wait.until((Function)new Function<WebDriver, List<WebElement>>(){

            public List<WebElement> apply(WebDriver driver) {
                List elements = driver.findElements(by);
                return elements.isEmpty() ? null : elements;
            }
        });
    }

    public static void findElementWaitUntilEnabledAndClick(By by) throws NotFoundException {
        Locator.findElementWaitUntilEnabledAndClick(null, by, 30000, 10000);
    }

    public static void findElementWaitUntilEnabledAndClick(WebElement parentElement, By by) throws NotFoundException {
        Locator.findElementWaitUntilEnabledAndClick(parentElement, by, 30000, 10000);
    }

    public static WebElement findElementWithTimeout(By by) throws NoSuchElementException {
        return Locator.findElementWithTimeout(by, 30000);
    }

    public static boolean hasElementWithTimeout(By by) {
        try {
            return Locator.findElementWithTimeout(by) != null;
        }
        catch (NoSuchElementException nsee) {
            return false;
        }
    }

    public static WebElement findElementWithTimeout(By by, int timeout) throws NoSuchElementException {
        return Locator.findElementWithTimeout(by, timeout, null);
    }

    public static boolean hasElementWithTimeout(By by, int timeout) {
        try {
            return Locator.findElementWithTimeout(by, timeout) != null;
        }
        catch (NoSuchElementException nsee) {
            return false;
        }
    }

    public static WebElement findElementWithTimeout(final By by, int timeout, final WebElement parentElement) throws NoSuchElementException {
        FluentWait<WebDriver> wait = Locator.getFluentWait();
        wait.withTimeout((long)timeout, TimeUnit.MILLISECONDS).ignoring(StaleElementReferenceException.class);
        try {
            return (WebElement)wait.until((Function)new Function<WebDriver, WebElement>(){

                public WebElement apply(WebDriver driver) {
                    try {
                        if (parentElement == null) {
                            return driver.findElement(by);
                        }
                        return parentElement.findElement(by);
                    }
                    catch (NoSuchElementException e) {
                        return null;
                    }
                }
            });
        }
        catch (TimeoutException e) {
            throw new NoSuchElementException(String.format("Couldn't find element '%s' after timeout", by));
        }
    }

    public static WebElement findElementWithTimeout(By by, WebElement parentElement) throws NoSuchElementException {
        return Locator.findElementWithTimeout(by, 30000, parentElement);
    }

    public static FluentWait<WebDriver> getFluentWait() {
        FluentWait wait = new FluentWait((Object)AbstractTest.driver);
        wait.withTimeout(30L, TimeUnit.SECONDS).pollingEvery(100L, TimeUnit.MILLISECONDS);
        return wait;
    }

    public static void waitForTextNotPresent(final WebElement element, final String text) {
        FluentWait<WebDriver> wait = Locator.getFluentWait();
        wait.until((Function)new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                try {
                    return !element.getText().contains(text);
                }
                catch (StaleElementReferenceException e) {
                    return null;
                }
            }
        });
    }

    public static void waitForTextPresent(By locator, String text) {
        FluentWait<WebDriver> wait = Locator.getFluentWait();
        wait.until((Function)ExpectedConditions.textToBePresentInElementLocated((By)locator, (String)text));
    }

    public static void waitForTextPresent(final WebElement element, final String text) {
        FluentWait<WebDriver> wait = Locator.getFluentWait();
        wait.until((Function)new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                try {
                    return element.getText().contains(text);
                }
                catch (StaleElementReferenceException e) {
                    return null;
                }
            }
        });
    }

    @Deprecated
    public static void findElementWaitUntilEnabledAndClick(By by, int findElementTimeout, int waitUntilEnabledTimeout) throws NotFoundException {
        Locator.findElementWaitUntilEnabledAndClick(null, by, findElementTimeout, waitUntilEnabledTimeout);
    }

    public static void findElementWaitUntilEnabledAndClick(WebElement parentElement, By by, int findElementTimeout, int waitUntilEnabledTimeout) throws NotFoundException {
        final WebElement element = Locator.findElementAndWaitUntilEnabled(parentElement, by, findElementTimeout, waitUntilEnabledTimeout);
        Locator.waitUntilGivenFunctionIgnoring(new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                return Locator.scrollAndForceClick(element);
            }
        }, StaleElementReferenceException.class);
    }

    public static void waitUntilEnabledAndClick(WebElement element) throws NotFoundException {
        Locator.waitUntilEnabledAndClick(element, 10000);
    }

    public static void waitUntilEnabledAndClick(final WebElement element, int waitUntilEnabledTimeout) throws NotFoundException {
        Locator.waitUntilEnabled(element, waitUntilEnabledTimeout);
        Locator.waitUntilGivenFunctionIgnoring(new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                return Locator.scrollAndForceClick(element);
            }
        }, StaleElementReferenceException.class);
    }

    public static void findElementWithTimeoutAndClick(final By by) throws NotFoundException {
        Locator.waitUntilGivenFunctionIgnoring(new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                WebElement element = Locator.findElementWithTimeout(by);
                element.click();
                return true;
            }
        }, StaleElementReferenceException.class);
    }

    public static void waitUntilElementNotPresent(final By locator) {
        FluentWait<WebDriver> wait = Locator.getFluentWait();
        wait.until((Function)new Function<WebDriver, By>(){

            public By apply(WebDriver driver) {
                try {
                    driver.findElement(locator);
                }
                catch (NoSuchElementException ex) {
                    return locator;
                }
                return null;
            }
        });
    }

    public static void waitUntilWindowClosed(String windowHandle) {
        FluentWait<WebDriver> wait = Locator.getFluentWait();
        wait.until(driver -> !driver.getWindowHandles().contains(windowHandle));
    }

    public static void waitUntilElementPresent(final By locator) {
        FluentWait<WebDriver> wait = Locator.getFluentWait();
        wait.ignoring(NoSuchElementException.class);
        wait.until((Function)new Function<WebDriver, WebElement>(){

            public WebElement apply(WebDriver driver) {
                return driver.findElement(locator);
            }
        });
    }

    public static void waitUntilEnabled(WebElement element) throws NotFoundException {
        Locator.waitUntilEnabled(element, 10000);
    }

    public static void waitUntilEnabled(final WebElement element, int timeout) throws NotFoundException {
        FluentWait<WebDriver> wait = Locator.getFluentWait();
        wait.withTimeout((long)timeout, TimeUnit.MILLISECONDS);
        Function<WebDriver, Boolean> function = new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                return element.isEnabled();
            }
        };
        try {
            wait.until((Function)function);
        }
        catch (TimeoutException e) {
            throw new NotFoundException("Element not enabled after timeout: " + element);
        }
    }

    public static void waitUntilGivenFunction(Function<WebDriver, Boolean> function) {
        Locator.waitUntilGivenFunctionIgnoring(function, null);
    }

    @SafeVarargs
    public static <K extends Throwable> void waitUntilGivenFunctionIgnoreAll(Function<WebDriver, Boolean> function, Class<? extends K> ... ignoredExceptions) {
        FluentWait<WebDriver> wait = Locator.getFluentWait();
        if (ignoredExceptions != null) {
            if (ignoredExceptions.length == 1) {
                wait.ignoring(ignoredExceptions[0]);
            } else {
                wait.ignoreAll(Arrays.asList(ignoredExceptions));
            }
        }
        wait.until(function);
    }

    public static <K extends Throwable> void waitUntilGivenFunctionIgnoring(Function<WebDriver, Boolean> function, Class<? extends K> ignoredException) {
        FluentWait<WebDriver> wait = Locator.getFluentWait();
        if (ignoredException != null) {
            wait.ignoring(ignoredException);
        }
        wait.until(function);
    }

    public static void waitUntilURLContains(String string) {
        Locator.waitUntilURLContainsOrNot(string, true);
    }

    private static void waitUntilURLContainsOrNot(String string, final boolean contain) {
        final String refurl = string;
        ExpectedCondition<Boolean> condition = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver d) {
                boolean result;
                String currentUrl = d.getCurrentUrl();
                boolean bl = result = !(currentUrl.contains(refurl) ^ contain);
                if (!result) {
                    AbstractTest.log.debug((Object)("currentUrl is : " + currentUrl));
                    AbstractTest.log.debug((Object)((contain ? "It should contains : " : "It should not contains : ") + refurl));
                }
                return result;
            }
        };
        WebDriverWait wait = new WebDriverWait((WebDriver)AbstractTest.driver, 30L);
        wait.until((Function)condition);
    }

    public static void waitUntilURLDifferentFrom(String url) {
        String refurl = url;
        AbstractTest.log.debug((Object)("Watch URL: " + refurl));
        ExpectedCondition urlchanged = d -> {
            if (d == null) {
                return false;
            }
            String currentUrl = d.getCurrentUrl();
            AbstractTest.log.debug((Object)("currentUrl is still: " + currentUrl));
            return !currentUrl.equals(refurl);
        };
        WebDriverWait wait = new WebDriverWait((WebDriver)AbstractTest.driver, 30L);
        wait.until((Function)urlchanged);
        if (AbstractTest.driver.getCurrentUrl().equals(refurl)) {
            AbstractTest.log.warn((Object)"Page change failed");
        }
    }

    public static void waitUntilURLNotContain(String string) {
        Locator.waitUntilURLContainsOrNot(string, false);
    }

    public static WebElement findParentTag(WebElement elt, String tagName) {
        try {
            By parentBy = By.xpath((String)"..");
            for (WebElement p = elt.findElement(parentBy); p != null; p = p.findElement(parentBy)) {
                if (!tagName.equals(p.getTagName())) continue;
                return p;
            }
        }
        catch (InvalidSelectorException invalidSelectorException) {
            // empty catch block
        }
        throw new NoSuchElementException(String.format("No parent element found with tag %s.", tagName));
    }

    public static void scrollToElement(WebElement element) {
        AbstractTest.driver.executeScript("arguments[0].scrollIntoView(false);", new Object[]{element});
    }

    public static boolean scrollAndForceClick(WebElement element) {
        RemoteWebDriver executor = AbstractTest.driver;
        Locator.scrollToElement(element);
        try {
            executor.executeScript("arguments[0].click();", new Object[]{element});
            return true;
        }
        catch (WebDriverException e) {
            if (e.getMessage().contains("Element is not clickable at point")) {
                AbstractTest.log.debug((Object)"Element is not clickable yet");
                return false;
            }
            throw e;
        }
    }
}

