/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.forms;

import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.google.common.base.Function;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.functionaltests.AbstractTest;
import org.nuxeo.functionaltests.AjaxRequestManager;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.fragment.WebFragmentImpl;
import org.nuxeo.functionaltests.pages.search.SearchPage;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.FluentWait;

public class Select2WidgetElement
extends WebFragmentImpl {
    private static final Log log = LogFactory.getLog(Select2WidgetElement.class);
    private static final String S2_CSS_ACTIVE_CLASS = "select2-active";
    private static final String S2_MULTIPLE_CURRENT_SELECTION_XPATH = "ul[@class='select2-choices']/li[@class='select2-search-choice']";
    private static final String S2_MULTIPLE_INPUT_XPATH = "ul/li/input";
    private static final String S2_SINGLE_CURRENT_SELECTION_XPATH = "a[@class='select2-choice']/span[@class='select2-chosen']";
    private static final String S2_SINGLE_INPUT_XPATH = "//*[@id='select2-drop']/div/input";
    private static final String S2_SUGGEST_RESULT_XPATH = "//*[@id='select2-drop']//li[contains(@class,'select2-result-selectable')]/div";
    private static final int SELECT2_LOADING_TIMEOUT = 20;
    protected boolean multiple = false;

    public Select2WidgetElement(WebDriver driver, String id) {
        this(driver, driver.findElement(By.id((String)id)));
    }

    public Select2WidgetElement(WebDriver driver, WebElement element) {
        super(driver, element);
    }

    public Select2WidgetElement(WebDriver driver, WebElement element, boolean multiple) {
        this(driver, element);
        this.multiple = multiple;
    }

    public WebElement getSelectedValue() {
        if (this.multiple) {
            throw new UnsupportedOperationException("The select2 is multiple and has multiple selected values");
        }
        return this.element.findElement(By.xpath((String)S2_SINGLE_CURRENT_SELECTION_XPATH));
    }

    public List<WebElement> getSelectedValues() {
        if (!this.multiple) {
            throw new UnsupportedOperationException("The select2 is not multiple and can't have multiple selected values");
        }
        return this.element.findElements(By.xpath((String)S2_MULTIPLE_CURRENT_SELECTION_XPATH));
    }

    protected String getSubmittedValue() {
        String eltId = this.element.getAttribute("id");
        String submittedEltId = this.element.getAttribute("id").substring("s2id_".length(), eltId.length());
        return this.driver.findElement(By.id((String)submittedEltId)).getAttribute("value");
    }

    public List<WebElement> getSuggestedEntries() {
        try {
            return this.driver.findElements(By.xpath((String)S2_SUGGEST_RESULT_XPATH));
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public void removeSelection() {
        if (this.multiple) {
            throw new UnsupportedOperationException("The select2 is multiple, use #removeSelection(value) instead");
        }
        this.element.findElement(By.className((String)"select2-search-choice-close")).click();
    }

    public void removeFromSelection(String displayedText) {
        if (!this.multiple) {
            throw new UnsupportedOperationException("The select2 is not multiple, use #removeSelection instead");
        }
        final String submittedValueBefore = this.getSubmittedValue();
        boolean found = false;
        for (WebElement el : this.getSelectedValues()) {
            if (!el.getText().equals(displayedText)) continue;
            Locator.waitUntilEnabledAndClick(el.findElement(By.xpath((String)"a[@class='select2-search-choice-close']")));
            found = true;
        }
        if (!found) {
            throw new ElementNotFoundException("remove link for select2 '" + displayedText + "' item", "", "");
        }
        Locator.waitUntilGivenFunction(new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                return !submittedValueBefore.equals(Select2WidgetElement.this.getSubmittedValue());
            }
        });
    }

    public void selectValue(String value) {
        this.selectValue(value, false, false);
    }

    public void selectValue(String value, boolean wait4A4J) {
        this.selectValue(value, wait4A4J, false);
    }

    public void selectValue(String value, boolean wait4A4J, boolean typeAll) {
        this.selectValue(value, wait4A4J, typeAll, true);
    }

    public void selectValue(String value, boolean wait4A4J, boolean typeAll, boolean click) {
        if (click) {
            this.clickSelect2Field();
        }
        WebElement suggestInput = this.getSuggestInput();
        int nbSuggested = Integer.MAX_VALUE;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            suggestInput.sendKeys(new CharSequence[]{"" + c});
            this.waitSelect2();
            if (i < 2) continue;
            if (this.getSuggestedEntries().size() > nbSuggested) {
                throw new IllegalArgumentException("More suggestions than expected for " + this.element.getAttribute("id"));
            }
            nbSuggested = this.getSuggestedEntries().size();
            if (!typeAll && nbSuggested == 1) break;
        }
        this.waitSelect2();
        List<WebElement> suggestions = this.getSuggestedEntries();
        if (suggestions == null || suggestions.isEmpty()) {
            log.warn((Object)("Suggestion for element " + this.element.getAttribute("id") + " returned no result for value '" + value + "'."));
            return;
        }
        WebElement suggestion = suggestions.get(0);
        if (suggestions.size() > 1) {
            log.warn((Object)("Suggestion for element " + this.element.getAttribute("id") + " returned more than 1 result for value '" + value + "', the first suggestion will be selected : " + suggestion.getText()));
        }
        AjaxRequestManager arm = new AjaxRequestManager(this.driver);
        if (wait4A4J) {
            arm.watchAjaxRequests();
        }
        try {
            suggestion.click();
        }
        catch (StaleElementReferenceException e) {
            suggestion = this.driver.findElement(By.xpath((String)S2_SUGGEST_RESULT_XPATH));
            suggestion.click();
        }
        if (wait4A4J) {
            arm.waitForAjaxRequests();
        }
    }

    public void selectValues(String[] values) {
        boolean click = true;
        for (String value : values) {
            this.selectValue(value, false, false, click);
            click = false;
        }
    }

    public List<WebElement> typeAndGetResult(String value) {
        this.clickSelect2Field();
        WebElement suggestInput = this.getSuggestInput();
        suggestInput.sendKeys(new CharSequence[]{value});
        try {
            this.waitSelect2();
        }
        catch (TimeoutException e) {
            log.warn((Object)("Suggestion timed out with input : " + value + ". Let's try with next letter."));
        }
        return this.getSuggestedEntries();
    }

    public void clickSelect2Field() {
        WebElement select2Field = null;
        select2Field = this.multiple ? this.element : this.element.findElement(By.xpath((String)"a[contains(@class,'select2-choice')]"));
        Locator.waitUntilEnabled(select2Field);
        Locator.scrollToElement(select2Field);
        select2Field.click();
    }

    private WebElement getSuggestInput() {
        WebElement suggestInput = null;
        suggestInput = this.multiple ? this.element.findElement(By.xpath((String)"ul/li[@class='select2-search-field']/input")) : this.driver.findElement(By.xpath((String)S2_SINGLE_INPUT_XPATH));
        return suggestInput;
    }

    private void waitSelect2() throws TimeoutException {
        FluentWait wait = new FluentWait((Object)(!this.multiple ? this.driver.findElement(By.xpath((String)S2_SINGLE_INPUT_XPATH)) : this.element.findElement(By.xpath((String)S2_MULTIPLE_INPUT_XPATH)))).withTimeout(20L, TimeUnit.SECONDS).pollingEvery(100L, TimeUnit.MILLISECONDS).ignoring(NoSuchElementException.class);
        Select2Wait s2WaitFunction = new Select2Wait();
        wait.until((Function)s2WaitFunction);
    }

    public void clearSuggestInput() {
        WebElement suggestInput = null;
        suggestInput = this.multiple ? this.driver.findElement(By.xpath((String)"//ul/li[@class='select2-search-field']/input")) : this.driver.findElement(By.xpath((String)S2_SINGLE_INPUT_XPATH));
        if (suggestInput != null) {
            suggestInput.clear();
        }
    }

    public SearchPage typeValueAndTypeEnter(String value) {
        this.clickSelect2Field();
        WebElement suggestInput = this.getSuggestInput();
        suggestInput.sendKeys(new CharSequence[]{value});
        try {
            this.waitSelect2();
        }
        catch (TimeoutException e) {
            log.warn((Object)("Suggestion timed out with input : " + value + ". Let's try with next letter."));
        }
        suggestInput.sendKeys(new CharSequence[]{Keys.RETURN});
        return AbstractTest.asPage(SearchPage.class);
    }

    public void hideSuggestionsByEscapeKey() {
        this.getSuggestInput().sendKeys(new CharSequence[]{Keys.ESCAPE});
    }

    private static class Select2Wait
    implements Function<WebElement, Boolean> {
        private Select2Wait() {
        }

        public Boolean apply(WebElement element) {
            boolean result = !element.getAttribute("class").contains(Select2WidgetElement.S2_CSS_ACTIVE_CLASS);
            return result;
        }
    }
}

